/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.capability;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class BlockFluidHandlerItemStack
extends FluidHandlerItemStack.SwapEmpty {
    private String tagName;

    public BlockFluidHandlerItemStack(ItemStack container, ItemStack emptyContainer, int capacity, String tagName) {
        super(container, emptyContainer, capacity);
        this.tagName = tagName;
    }

    @Nonnull
    public FluidStack getFluid() {
        CompoundTag tagCompound = this.container.getTag();
        if (tagCompound == null || !tagCompound.contains("BlockEntityTag") || !tagCompound.getCompound("BlockEntityTag").contains(this.tagName)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tagCompound.getCompound("BlockEntityTag").getCompound(this.tagName));
    }

    protected void setFluid(FluidStack fluid) {
        if (!this.container.hasTag()) {
            CompoundTag compoundNBT = new CompoundTag();
            CompoundTag blockEntityTag = new CompoundTag();
            compoundNBT.put("BlockEntityTag", (Tag)blockEntityTag);
            this.container.setTag(compoundNBT);
        }
        CompoundTag fluidTag = new CompoundTag();
        fluid.writeToNBT(fluidTag);
        this.container.getTag().getCompound("BlockEntityTag").put(this.tagName, (Tag)fluidTag);
    }
}

