/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.capability;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BLHBlockItemHandlerItemStack
implements IItemHandler {
    public final ItemStack stack;
    public final int slotLimit;

    public BLHBlockItemHandlerItemStack(ItemStack stack, int slotLimit) {
        this.stack = stack;
        this.slotLimit = slotLimit;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemStack copied = this.getStack();
        copied.setCount(this.getAmount());
        return copied;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isItemValid(slot, stack)) {
            int amount = this.getSlotLimit(slot);
            int stored = this.getAmount();
            int inserted = Math.min(amount - stored, stack.getCount());
            if (this.getVoid()) {
                inserted = stack.getCount();
            }
            if (!simulate) {
                this.setStack(stack);
                this.setAmount(Math.min(stored + inserted, amount));
            }
            if (inserted == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.getCount() - inserted));
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack blStack = this.getStack();
        int stored = this.getAmount();
        if (blStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (stored <= amount) {
            ItemStack out = blStack.copy();
            int newAmount = stored;
            if (!simulate) {
                this.setAmount(0);
            }
            out.setCount(newAmount);
            return out;
        }
        if (!simulate) {
            this.setAmount(stored - amount);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)blStack, (int)amount);
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        ItemStack current = this.getStack();
        return current.isEmpty() || ItemStack.isSameItemSameTags((ItemStack)current, (ItemStack)stack);
    }

    public int getAmount() {
        CompoundTag tag = this.getTag();
        if (tag != null && tag.contains("stored")) {
            return tag.getInt("stored");
        }
        return 0;
    }

    public ItemStack getStack() {
        CompoundTag tag = this.getTag();
        if (tag != null && tag.contains("blStack")) {
            return ItemStack.of((CompoundTag)tag.getCompound("blStack"));
        }
        return ItemStack.EMPTY;
    }

    public boolean getVoid() {
        CompoundTag tag = this.getTag();
        if (tag != null && tag.contains("voidItems")) {
            return tag.getBoolean("voidItems");
        }
        return true;
    }

    private void setAmount(int amount) {
        CompoundTag tag = this.getTag();
        if (tag == null) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.put("BlockEntityTag", (Tag)new CompoundTag());
            this.stack.setTag(compoundNBT);
        }
        this.stack.getTag().getCompound("BlockEntityTag").putInt("stored", amount);
    }

    private void setStack(ItemStack stack) {
        CompoundTag tag = this.getTag();
        if (tag == null) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.put("BlockEntityTag", (Tag)new CompoundTag());
            this.stack.setTag(compoundNBT);
        }
        if (!stack.isEmpty()) {
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        }
        this.stack.getTag().getCompound("BlockEntityTag").put("blStack", (Tag)stack.serializeNBT());
        this.stack.getTag().getCompound("BlockEntityTag").putBoolean("hasNBT", stack.hasTag());
    }

    private CompoundTag getTag() {
        if (this.stack.hasTag() && this.stack.getTag().contains("BlockEntityTag")) {
            return this.stack.getTag().getCompound("BlockEntityTag");
        }
        return null;
    }
}

