/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.FilteredTransporterType;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.TileUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.joml.Vector3f;

public class TransporterWorldType
extends FilteredTransporterType<ItemStack, IItemHandler> {
    private int extractSlot = 0;

    public TransporterWorldType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
    }

    @Override
    public RegulatorFilter<ItemStack, IItemHandler> createFilter() {
        return new RegulatorFilter<ItemStack, IItemHandler>(20, 20, 5, 3, 16, 64, 8192, ""){

            @Override
            public int matches(ItemStack stack, IItemHandler itemHandler, boolean isRegulated) {
                if (this.isEmpty()) {
                    return stack.getCount();
                }
                int amount = 0;
                if (isRegulated) {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        if (!ItemStack.isSameItem((ItemStack)itemHandler.getStackInSlot(i), (ItemStack)stack)) continue;
                        amount += itemHandler.getStackInSlot(i).getCount();
                    }
                }
                for (IFilter.GhostSlot slot : this.getFilter()) {
                    if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)slot.getStack())) continue;
                    int maxAmount = isRegulated ? slot.getAmount() : Integer.MAX_VALUE;
                    int returnAmount = Math.min(stack.getCount(), maxAmount - amount);
                    if (returnAmount <= 0) continue;
                    return returnAmount;
                }
                return 0;
            }
        };
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getSpeed();
        if (!this.getLevel().isClientSide && (float)this.getLevel().getGameTime() % Math.max(1.0f, 4.0f - speed) == 0.0f) {
            IBlockContainer container = this.getContainer();
            if (this.getAction() == TransporterTypeFactory.TransporterAction.EXTRACT && container instanceof TransporterTile) {
                TileUtil.getTileEntity((BlockGetter)this.getLevel(), (BlockPos)this.getPos().relative(this.getSide())).ifPresent(tileEntity -> tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, this.getSide().getOpposite()).ifPresent(origin -> {
                    if (origin.getSlots() <= 0) {
                        return;
                    }
                    if (origin.getStackInSlot(this.extractSlot).isEmpty() || !this.filter(this.getFilter(), this.isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)origin, false)) {
                        this.findSlot((IItemHandler)origin);
                    }
                    if (!origin.getStackInSlot(this.extractSlot).isEmpty() && this.filter(this.getFilter(), this.isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)origin, false)) {
                        int amount = (int)(1.0f * this.getEfficiency());
                        ItemStack extracted = origin.extractItem(this.extractSlot, amount, false);
                        if (extracted.isEmpty()) {
                            return;
                        }
                        ItemEntity item = new ItemEntity(this.getLevel(), (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.2, (double)this.getPos().getZ() + 0.5, extracted);
                        item.setDeltaMovement(0.0, 0.0, 0.0);
                        item.setPickUpDelay(4);
                        item.setItem(extracted);
                        this.getLevel().addFreshEntity((Entity)item);
                    }
                }));
            }
            if (this.getAction() == TransporterTypeFactory.TransporterAction.INSERT && container instanceof TransporterTile) {
                TileUtil.getTileEntity((BlockGetter)this.getLevel(), (BlockPos)this.getPos().relative(this.getSide())).ifPresent(tileEntity -> tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, this.getSide().getOpposite()).ifPresent(origin -> {
                    for (ItemEntity item : this.getLevel().getEntitiesOfClass(ItemEntity.class, new AABB((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), (double)(this.getPos().getX() + 1), (double)(this.getPos().getY() + 1), (double)(this.getPos().getZ() + 1)))) {
                        int i;
                        if (!item.isAlive()) continue;
                        ItemStack stack = item.getItem().copy();
                        int amount = Math.min(stack.getCount(), (int)(1.0f * this.getEfficiency()));
                        stack.setCount(amount);
                        amount = this.getFilter().matches(stack, (IItemHandler)origin, this.isRegulated());
                        if (amount <= 0) continue;
                        stack.setCount(amount);
                        if (stack.isEmpty() || !this.filter(this.getFilter(), this.isWhitelist(), stack, (IItemHandler)origin, this.isRegulated()) || (i = 0) >= origin.getSlots()) continue;
                        stack = origin.insertItem(i, stack, false);
                        ItemStack originStack = item.getItem().copy();
                        originStack.shrink(amount - stack.getCount());
                        if (originStack.isEmpty()) {
                            item.setItem(ItemStack.EMPTY);
                            item.remove(Entity.RemovalReason.KILLED);
                            return;
                        }
                        item.setItem(originStack);
                        return;
                    }
                }));
            }
        }
    }

    private void findSlot(IItemHandler itemHandler) {
        for (int i = this.extractSlot; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).isEmpty() || !this.filter(this.getFilter(), this.isWhitelist(), itemHandler.getStackInSlot(i), itemHandler, false)) continue;
            this.extractSlot = i;
            return;
        }
        this.extractSlot = 0;
    }

    private boolean filter(RegulatorFilter<ItemStack, IItemHandler> filter, boolean whitelist, ItemStack stack, IItemHandler handler, boolean isRegulated) {
        int accepts = filter.matches(stack, handler, isRegulated);
        if (whitelist && filter.isEmpty()) {
            return false;
        }
        return filter.isEmpty() != (whitelist == accepts > 0);
    }

    @Override
    public void updateClient() {
        super.updateClient();
    }

    @Override
    public void handleRenderSync(Direction origin, CompoundTag compoundNBT) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, PoseStack stack, int combinedOverlayIn, MultiBufferSource buffer, float frame, Level level) {
        super.renderTransfer(pos, direction, step, stack, combinedOverlayIn, buffer, frame, level);
    }

    public static class Factory
    extends TransporterTypeFactory {
        public Factory() {
            super("world");
        }

        @Override
        public TransporterType create(IBlockContainer container, Direction face, TransporterTypeFactory.TransporterAction action) {
            return new TransporterWorldType(container, this, face, action);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, TransporterTypeFactory.TransporterAction action) {
            return new ResourceLocation("industrialforegoing", "block/transporters/world_transporter_" + action.name().toLowerCase() + "_" + upgradeSide.getSerializedName().toLowerCase());
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("industrialforegoing:block/transporters/world"), new ResourceLocation("industrialforegoing:block/base/bottom")});
        }

        @Override
        public boolean canBeAttachedAgainst(Level world, BlockPos pos, Direction face) {
            return TileUtil.getTileEntity((BlockGetter)world, (BlockPos)pos).map(tileEntity -> tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, face).isPresent()).orElse(false);
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "block/transporters/world_transporter_" + TransporterTypeFactory.TransporterAction.EXTRACT.name().toLowerCase() + "_" + Direction.NORTH.getSerializedName().toLowerCase());
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem(), (int)2).pattern("IPI").pattern("GMG").pattern("ICI").define(Character.valueOf('I'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('P'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('G'), (ItemLike)Items.HOPPER).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).define(Character.valueOf('C'), (ItemLike)Items.DROPPER).save(consumer);
        }
    }
}

