/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage;

import com.buuz135.industrial.block.IndustrialBlock;
import com.buuz135.industrial.block.transportstorage.tile.BlackHoleUnitTile;
import com.buuz135.industrial.capability.BLHBlockItemHandlerItemStack;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.LangUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.RegistryObject;

public class BlackHoleUnitBlock
extends IndustrialBlock<BlackHoleUnitTile> {
    private Rarity rarity;

    public BlackHoleUnitBlock(Rarity rarity) {
        super(rarity.name().toLowerCase() + "_black_hole_unit", BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.IRON_BLOCK), BlackHoleUnitTile.class, ModuleTransportStorage.TAB_TRANSPORT);
        this.rarity = rarity;
    }

    public BlockEntityType.BlockEntitySupplier<BlackHoleUnitTile> getTileEntityFactory() {
        return (p_155268_, p_155269_) -> new BlackHoleUnitTile((BasicTileBlock<BlackHoleUnitTile>)this, this.getRarityType(), this.rarity, p_155268_, p_155269_);
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            ItemStack contain;
            if (iItemHandler instanceof BLHBlockItemHandlerItemStack && !(contain = ((BLHBlockItemHandlerItemStack)iItemHandler).getStack()).isEmpty()) {
                tooltip.add((Component)Component.literal((String)(ChatFormatting.GOLD + LangUtil.getString((String)"text.industrialforegoing.tooltip.item", (Object[])new Object[0]) + ": " + ChatFormatting.WHITE + contain.getHoverName().getString())));
                tooltip.add((Component)Component.literal((String)(ChatFormatting.GOLD + LangUtil.getString((String)"text.industrialforegoing.tooltip.contains", (Object[])new Object[0]) + ": " + ChatFormatting.WHITE + new DecimalFormat().format(((BLHBlockItemHandlerItemStack)iItemHandler).getAmount()) + ChatFormatting.DARK_AQUA + " " + LangUtil.getString((String)"text.industrialforegoing.tooltip.items", (Object[])new Object[0]))));
            }
        });
        tooltip.add((Component)Component.literal((String)(ChatFormatting.GOLD + LangUtil.getString((String)"text.industrialforegoing.tooltip.can_hold", (Object[])new Object[0]) + ": " + ChatFormatting.WHITE + new DecimalFormat().format(BlockUtils.getStackAmountByRarity(this.rarity)) + ChatFormatting.DARK_AQUA + " " + LangUtil.getString((String)"text.industrialforegoing.tooltip.items", (Object[])new Object[0]))));
        if (stack.hasTag() && stack.getTag().contains("BlockEntityTag") && stack.getTag().getCompound("BlockEntityTag").contains("voidItems") && stack.getTag().getCompound("BlockEntityTag").getBoolean("voidItems")) {
            tooltip.add((Component)Component.literal((String)(ChatFormatting.GOLD + LangUtil.getString((String)"text.industrialforegoing.tooltip.void_items", (Object[])new Object[0]))));
        }
    }

    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public void attack(BlockState state, Level worldIn, BlockPos pos, Player player) {
        this.getTile((BlockGetter)worldIn, pos).ifPresent(tile -> tile.onClicked(player));
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        CopyNbtFunction.Builder nbtBuilder = CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY);
        nbtBuilder.copy("stored", "BlockEntityTag.stored");
        nbtBuilder.copy("blStack", "BlockEntityTag.blStack");
        nbtBuilder.copy("voidItems", "BlockEntityTag.voidItems");
        nbtBuilder.copy("hasNBT", "BlockEntityTag.hasNBT");
        return blockLootTables.droppingSelfWithNbt((ItemLike)this, nbtBuilder);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.create();
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        if (this.rarity == Rarity.COMMON) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PPP").pattern("CEC").pattern("CMC").define(Character.valueOf('P'), Tags.Items.INGOTS_IRON).define(Character.valueOf('E'), IndustrialTags.Items.GEAR_IRON).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).save(consumer);
        } else {
            TagKey<Item> tag = IndustrialTags.Items.MACHINE_FRAME_PITY;
            if (this.rarity == ModuleCore.SIMPLE_RARITY) {
                tag = IndustrialTags.Items.MACHINE_FRAME_SIMPLE;
            }
            if (this.rarity == ModuleCore.ADVANCED_RARITY) {
                tag = IndustrialTags.Items.MACHINE_FRAME_ADVANCED;
            }
            if (this.rarity == ModuleCore.SUPREME_RARITY) {
                tag = IndustrialTags.Items.MACHINE_FRAME_SUPREME;
            }
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PPP").pattern("NEN").pattern("CMC").define(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).define(Character.valueOf('N'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('E'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('M'), tag).save(consumer);
        }
    }

    private BlockEntityType getRarityType() {
        if (this.rarity == Rarity.COMMON) {
            return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_UNIT_COMMON.getRight()).get();
        }
        if (this.rarity == ModuleCore.SIMPLE_RARITY) {
            return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_UNIT_SIMPLE.getRight()).get();
        }
        if (this.rarity == ModuleCore.ADVANCED_RARITY) {
            return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_UNIT_ADVANCED.getRight()).get();
        }
        if (this.rarity == ModuleCore.SUPREME_RARITY) {
            return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_UNIT_SUPREME.getRight()).get();
        }
        return (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_UNIT_PITY.getRight()).get();
    }

    public static class BlackHoleUnitCapabilityProvider
    implements ICapabilityProvider {
        private final ItemStack stack;
        private LazyOptional<BLHBlockItemHandlerItemStack> optional;

        public BlackHoleUnitCapabilityProvider(ItemStack stack, Rarity rarity) {
            this.stack = stack;
            this.optional = LazyOptional.of(() -> new BLHBlockItemHandlerItemStack(stack, BlockUtils.getStackAmountByRarity(rarity)));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap != null && cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }
    }

    public static class BlackHoleUnitItem
    extends BlockItem {
        private Rarity rarity;

        public BlackHoleUnitItem(Block blockIn, Item.Properties builder, Rarity rarity) {
            super(blockIn, builder);
            this.rarity = rarity;
        }

        @Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            return new BlackHoleUnitCapabilityProvider(stack, this.rarity);
        }

        @Nullable
        public String getCreatorModId(ItemStack itemStack) {
            return Component.translatable((String)("itemGroup.industrialforegoing_" + ModuleTransportStorage.TAB_TRANSPORT.getResourceLocation().getPath())).getString();
        }
    }
}

