/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.api.IMachineSettings;
import com.buuz135.industrial.item.addon.ProcessingAddonItem;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IEnumValues;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.api.redstone.IRedstoneReader;
import com.hrznstudio.titanium.api.redstone.IRedstoneState;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.redstone.RedstoneAction;
import com.hrznstudio.titanium.block.redstone.RedstoneManager;
import com.hrznstudio.titanium.block.redstone.RedstoneState;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.block.tile.MachineTile;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.bundle.TankInteractionBundle;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.button.RedstoneControlButtonComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public abstract class IndustrialMachineTile<T extends IndustrialMachineTile<T>>
extends MachineTile<T>
implements IRedstoneReader,
IMachineSettings {
    private static String settingsAddons = "MACHINE_ADDONS";
    private static String redstoneMode = "REDSTONE_MODE";
    private static String sidenessTank = "SIDENESS_TANK";
    private static String sidenessInventory = "SIDENESS_INVENTORY";
    private static String filter = "FILTER";
    @Save
    private TankInteractionBundle<IndustrialMachineTile> tankBundle;
    @Save
    private RedstoneManager<RedstoneAction> redstoneManager = new RedstoneManager((IEnumValues)RedstoneAction.IGNORE, false);
    private RedstoneControlButtonComponent<RedstoneAction> redstoneButton = new RedstoneControlButtonComponent(154, 84, 14, 14, () -> this.redstoneManager, () -> this);
    private boolean tankBundleAdded = false;

    public IndustrialMachineTile(Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> basicTileBlock, BlockPos blockPos, BlockState blockState) {
        super((BasicTileBlock)((RegistryObject)basicTileBlock.getLeft()).get(), (BlockEntityType)((RegistryObject)basicTileBlock.getRight()).get(), blockPos, blockState);
        this.addButton((ButtonComponent)this.redstoneButton);
    }

    public void addTank(FluidTankComponent<T> tank) {
        super.addTank(tank);
        if (!this.tankBundleAdded) {
            this.tankBundle = new TankInteractionBundle(() -> this.getCapability(ForgeCapabilities.FLUID_HANDLER), 175, 94, (BasicTile)this, 10);
            this.addBundle((IComponentBundle)this.tankBundle);
            this.tankBundleAdded = true;
        }
    }

    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.SPEED)) {
            return !this.hasAugmentInstalled(AugmentTypes.SPEED);
        }
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.EFFICIENCY)) {
            return !this.hasAugmentInstalled(AugmentTypes.EFFICIENCY);
        }
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)ProcessingAddonItem.PROCESSING)) {
            return !this.hasAugmentInstalled(ProcessingAddonItem.PROCESSING);
        }
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)RangeAddonItem.RANGE)) {
            return !this.hasAugmentInstalled(RangeAddonItem.RANGE);
        }
        return false;
    }

    public RedstoneManager<RedstoneAction> getRedstoneManager() {
        return this.redstoneManager;
    }

    public IRedstoneState getEnvironmentValue(boolean strongPower, Direction direction) {
        if (strongPower) {
            if (direction == null) {
                return this.level.hasNeighborSignal(this.worldPosition) ? RedstoneState.ON : RedstoneState.OFF;
            }
            return this.level.hasSignal(this.worldPosition, direction) ? RedstoneState.ON : RedstoneState.OFF;
        }
        return this.level.getBestNeighborSignal(this.worldPosition) > 0 ? RedstoneState.ON : RedstoneState.OFF;
    }

    public void onNeighborChanged(Block blockIn, BlockPos fromPos) {
        super.onNeighborChanged(blockIn, fromPos);
        this.redstoneManager.setLastRedstoneState(this.getEnvironmentValue(false, null).isReceivingRedstone());
    }

    public IAssetProvider getAssetProvider() {
        return IndustrialAssetProvider.INSTANCE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.clientTick(level, pos, state, blockEntity);
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        CompoundTag intermediateTag;
        SidedInventoryComponent sided;
        if (tag.contains(settingsAddons)) {
            List<ItemStack> stacks = IMachineSettings.readInventory(tag.getCompound(settingsAddons));
            block0: for (ItemStack stack : stacks) {
                if (!this.canAcceptAugment(stack)) continue;
                for (ItemStack stackPlayer : player.inventory.items) {
                    if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)stackPlayer)) continue;
                    ItemStack copiedStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stackPlayer, (int)1);
                    if (!ItemHandlerHelper.insertItem((IItemHandler)this.getAugmentInventory(), (ItemStack)copiedStack, (boolean)false).isEmpty()) continue block0;
                    stackPlayer.shrink(1);
                    continue block0;
                }
            }
        }
        if (tag.contains(redstoneMode)) {
            NBTManager.getInstance().readTileEntity((BlockEntity)this, tag.getCompound(redstoneMode));
        }
        if (tag.contains(sidenessInventory)) {
            for (InventoryComponent inventoryHandler : this.getMultiInventoryComponent().getInventoryHandlers()) {
                if (!(inventoryHandler instanceof SidedInventoryComponent)) continue;
                sided = (SidedInventoryComponent)inventoryHandler;
                if (!tag.getCompound(sidenessInventory).contains(sided.getName())) continue;
                intermediateTag = tag.getCompound(sidenessInventory).getCompound(sided.getName());
                for (String allKey : intermediateTag.getAllKeys()) {
                    sided.getFacingModes().put(FacingUtil.Sideness.valueOf((String)allKey), IFacingComponent.FaceMode.valueOf((String)intermediateTag.getString(allKey)));
                }
            }
        }
        if (tag.contains(sidenessTank)) {
            for (FluidTankComponent fluidTankComponent : this.getMultiTankComponent().getTanks()) {
                if (!(fluidTankComponent instanceof SidedFluidTankComponent)) continue;
                sided = (SidedFluidTankComponent)fluidTankComponent;
                if (!tag.getCompound(sidenessTank).contains(sided.getName())) continue;
                intermediateTag = tag.getCompound(sidenessTank).getCompound(sided.getName());
                for (String allKey : intermediateTag.getAllKeys()) {
                    sided.getFacingModes().put(FacingUtil.Sideness.valueOf((String)allKey), IFacingComponent.FaceMode.valueOf((String)intermediateTag.getString(allKey)));
                }
            }
        }
        if (tag.contains(filter)) {
            for (IFilter iFilter : this.getMultiFilterComponent().getFilters()) {
                if (!tag.getCompound(filter).contains(iFilter.getName())) continue;
                iFilter.deserializeNBT((Tag)tag.getCompound(filter).getCompound(iFilter.getName()));
            }
        }
        this.markForUpdate();
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        CompoundTag intermediateTag;
        SidedInventoryComponent sided;
        tag.put(settingsAddons, (Tag)IMachineSettings.writeInventory((InventoryComponent)this.getAugmentInventory()));
        tag.put(redstoneMode, (Tag)NBTManager.getInstance().writeTileEntityObject((BlockEntity)this, this.redstoneManager, new CompoundTag()));
        if (this.getMultiInventoryComponent() != null) {
            CompoundTag sideInvTag = new CompoundTag();
            for (InventoryComponent inventoryHandler : this.getMultiInventoryComponent().getInventoryHandlers()) {
                if (!(inventoryHandler instanceof SidedInventoryComponent)) continue;
                sided = (SidedInventoryComponent)inventoryHandler;
                intermediateTag = new CompoundTag();
                for (FacingUtil.Sideness facing : sided.getFacingModes().keySet()) {
                    intermediateTag.putString(facing.name(), ((IFacingComponent.FaceMode)sided.getFacingModes().get(facing)).name());
                }
                sideInvTag.put(sided.getName(), (Tag)intermediateTag);
            }
            tag.put(sidenessInventory, (Tag)sideInvTag);
        }
        if (this.getMultiTankComponent() != null) {
            CompoundTag sideTankTag = new CompoundTag();
            for (FluidTankComponent fluidTankComponent : this.getMultiTankComponent().getTanks()) {
                if (!(fluidTankComponent instanceof SidedFluidTankComponent)) continue;
                sided = (SidedFluidTankComponent)fluidTankComponent;
                intermediateTag = new CompoundTag();
                for (FacingUtil.Sideness facing : sided.getFacingModes().keySet()) {
                    intermediateTag.putString(facing.name(), ((IFacingComponent.FaceMode)sided.getFacingModes().get(facing)).name());
                }
                sideTankTag.put(sided.getName(), (Tag)intermediateTag);
            }
            tag.put(sidenessTank, (Tag)sideTankTag);
        }
        if (this.getMultiFilterComponent() != null) {
            CompoundTag filterTag = new CompoundTag();
            for (IFilter iFilter : this.getMultiFilterComponent().getFilters()) {
                filterTag.put(iFilter.getName(), iFilter.serializeNBT());
            }
            tag.put(filter, (Tag)filterTag);
        }
    }
}

