/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.ResourcefulFurnaceConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ResourcefulFurnaceTile
extends IndustrialProcessingTile<ResourcefulFurnaceTile> {
    private int getPowerPerTick;
    @Save
    private SidedInventoryComponent<ResourcefulFurnaceTile> input = (SidedInventoryComponent)new SidedInventoryComponent("input", 44, 22, 3, 0).setColor(DyeColor.BLUE).setSlotLimit(1).setRange(1, 3).setOnSlotChanged((itemStack, integer) -> this.checkForRecipe((int)integer));
    @Save
    private SidedInventoryComponent<ResourcefulFurnaceTile> output;
    @Save
    private SidedFluidTankComponent<ResourcefulFurnaceTile> tank;
    private SmeltingRecipe[] recipes;

    public ResourcefulFurnaceTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.RESOURCEFUL_FURNACE, 74, 40, blockPos, blockState);
        this.addInventory((InventoryComponent)this.input);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 110, 22, 3, 1).setColor(DyeColor.ORANGE).setInputFilter((itemStack, integer) -> false).setRange(1, 3);
        this.addInventory((InventoryComponent)this.output);
        this.tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", ResourcefulFurnaceConfig.maxEssenceTankSize, 132, 20, 2).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.DRAIN);
        this.addTank(this.tank);
        this.recipes = new SmeltingRecipe[3];
        this.getPowerPerTick = ResourcefulFurnaceConfig.powerPerTick;
    }

    public void onLoad() {
        super.onLoad();
        this.checkForRecipe(0);
        this.checkForRecipe(1);
        this.checkForRecipe(2);
    }

    public void setChanged() {
        super.setChanged();
        this.checkForRecipe(0);
        this.checkForRecipe(1);
        this.checkForRecipe(2);
    }

    private void checkForRecipe(int slot) {
        Collection recipes = RecipeUtil.getCookingRecipes((Level)this.level);
        this.recipes[slot] = recipes.stream().filter(furnaceRecipe -> ((Ingredient)furnaceRecipe.getIngredients().get(0)).test(this.input.getStackInSlot(slot))).findAny().orElse(null);
    }

    @Override
    public boolean canIncrease() {
        for (SmeltingRecipe recipe : this.recipes) {
            if (recipe == null || !ItemHandlerHelper.insertItem(this.output, (ItemStack)recipe.getResultItem(this.level.registryAccess()).copy(), (boolean)true).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            for (int i = 0; i < this.recipes.length; ++i) {
                SmeltingRecipe recipe = this.recipes[i];
                if (recipe == null || !ItemHandlerHelper.insertItem(this.output, (ItemStack)recipe.getResultItem(this.level.registryAccess()).copy(), (boolean)true).isEmpty() || !ItemHandlerHelper.insertItem(this.output, (ItemStack)recipe.getResultItem(this.level.registryAccess()).copy(), (boolean)true).isEmpty()) continue;
                this.input.setStackInSlot(i, ItemStack.EMPTY);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)recipe.getResultItem(this.level.registryAccess()).copy(), (boolean)false);
                this.tank.fillForced(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), (int)(recipe.getExperience() * 20.0f)), IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    protected EnergyStorageComponent<ResourcefulFurnaceTile> createEnergyStorage() {
        return new EnergyStorageComponent(ResourcefulFurnaceConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return this.getPowerPerTick;
    }

    @Nonnull
    public ResourcefulFurnaceTile getSelf() {
        return this;
    }
}

