/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.resourceproduction.MechanicalDirtConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MechanicalDirtTile
extends IndustrialWorkingTile<MechanicalDirtTile> {
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<MechanicalDirtTile> meat = (SidedFluidTankComponent)new SidedFluidTankComponent("meat", MechanicalDirtConfig.maxMeatTankSize, 43, 20, 0).setColor(DyeColor.BROWN).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)ModuleCore.MEAT.getSourceFluid().get()));

    public MechanicalDirtTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.MECHANICAL_DIRT, MechanicalDirtConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.meat);
        this.getPowerPerOperation = MechanicalDirtConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        Mob entity;
        if (this.level.random.nextDouble() > 0.1 || this.level.getDifficulty() == Difficulty.PEACEFUL || this.level.isDay() && (float)this.level.getBrightness(LightLayer.SKY, this.worldPosition.above()) > 0.5f && this.level.canSeeSkyFromBelowWater(this.worldPosition.above()) || this.level.getEntitiesOfClass(Mob.class, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).move(this.worldPosition).inflate(3.0)).size() > 10 || this.level.getMaxLocalRawBrightness(this.worldPosition.above()) > 7) {
            if (this.hasEnergy(this.getPowerPerOperation / 10)) {
                return new IndustrialWorkingTile.WorkAction(this, 0.5f, this.getPowerPerOperation / 10);
            }
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        if (this.meat.getFluidAmount() >= 20 && this.isServer() && (entity = this.getMobToSpawn()) != null) {
            this.level.addFreshEntity((Entity)entity);
            this.meat.drainForced(20, IFluidHandler.FluidAction.EXECUTE);
            if (this.hasEnergy(this.getPowerPerOperation)) {
                return new IndustrialWorkingTile.WorkAction(this, 0.5f, this.getPowerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private Mob getMobToSpawn() {
        List spawnListEntries = ((ServerLevel)this.level).getChunkSource().getGenerator().getMobsAt(this.level.getBiome(this.worldPosition.above()), ((ServerLevel)this.level).structureManager(), MobCategory.MONSTER, this.worldPosition.above()).unwrap();
        if (spawnListEntries.size() == 0) {
            return null;
        }
        MobSpawnSettings.SpawnerData spawnListEntry = (MobSpawnSettings.SpawnerData)spawnListEntries.get(this.level.random.nextInt(spawnListEntries.size()));
        if (!SpawnPlacements.checkSpawnRules((EntityType)spawnListEntry.type, (ServerLevelAccessor)((ServerLevelAccessor)this.level), (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)this.worldPosition.above(), (RandomSource)this.level.random)) {
            return null;
        }
        Entity entity = spawnListEntry.type.create(this.level);
        if (entity instanceof Mob) {
            ((Mob)entity).finalizeSpawn((ServerLevelAccessor)this.level, this.level.getCurrentDifficultyAt(this.worldPosition), MobSpawnType.NATURAL, null, null);
            entity.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.001, (double)this.worldPosition.getZ() + 0.5);
            if (this.level.noCollision(entity) && this.level.isUnobstructed(entity, this.level.getBlockState(this.worldPosition.above()).getShape((BlockGetter)this.level, this.worldPosition.above()))) {
                return (Mob)entity;
            }
        }
        return null;
    }

    public SidedFluidTankComponent<MechanicalDirtTile> getMeat() {
        return this.meat;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, MechanicalDirtTile blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (this.level.getGameTime() % 5L == 0L) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockEntity tile = level.getBlockEntity(this.worldPosition.relative(direction));
                if (!(tile instanceof MechanicalDirtTile)) continue;
                int difference = this.meat.getFluidAmount() - ((MechanicalDirtTile)tile).getMeat().getFluidAmount();
                if (difference > 0) {
                    difference = difference <= 25 ? (difference /= 2) : 25;
                    if (this.meat.getFluidAmount() >= difference) {
                        this.meat.drainForced(((MechanicalDirtTile)tile).getMeat().fill(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), this.meat.drainForced(difference, IFluidHandler.FluidAction.SIMULATE).getAmount()), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if ((difference = this.getEnergyStorage().getEnergyStored() - ((MechanicalDirtTile)tile).getEnergyStorage().getEnergyStored()) <= 0) continue;
                if (difference <= 1000 && difference > 1) {
                    difference /= 2;
                }
                if (difference > 1000) {
                    difference = 1000;
                }
                if (this.getEnergyStorage().getEnergyStored() < difference) continue;
                this.getEnergyStorage().extractEnergy(((MechanicalDirtTile)tile).getEnergyStorage().receiveEnergy(difference, false), false);
            }
        }
    }

    protected EnergyStorageComponent<MechanicalDirtTile> createEnergyStorage() {
        return new EnergyStorageComponent(MechanicalDirtConfig.maxStoredPower, 10, 20);
    }

    @Nonnull
    public MechanicalDirtTile getSelf() {
        return this;
    }

    @Override
    public int getMaxProgress() {
        return MechanicalDirtConfig.maxProgress;
    }
}

