/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.BlockPlacerConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IFFakePlayer;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;

public class BlockPlacerTile
extends IndustrialAreaWorkingTile<BlockPlacerTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedInventoryComponent<BlockPlacerTile> input = (SidedInventoryComponent)new SidedInventoryComponent("input", 54, 22, 18, 0).setColor(DyeColor.BLUE).setRange(6, 3);

    public BlockPlacerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.BLOCK_PLACER, RangeManager.RangeType.BEHIND, false, BlockPlacerConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.input);
        this.getMaxProgress = BlockPlacerConfig.maxProgress;
        this.getPowerPerOperation = BlockPlacerConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation) && BlockUtils.canBlockBeBroken(this.level, this.worldPosition)) {
            BlockPos pointed = this.getPointedBlockPos();
            if (this.isLoaded(pointed) && this.level.isEmptyBlock(pointed)) {
                for (int i = 0; i < this.input.getSlots(); ++i) {
                    IFFakePlayer fakePlayer;
                    if (this.input.getStackInSlot(i).isEmpty() || !(this.input.getStackInSlot(i).getItem() instanceof BlockItem) || !(fakePlayer = (IFFakePlayer)IndustrialForegoing.getFakePlayer(this.level, pointed)).placeBlock(this.level, pointed, this.input.getStackInSlot(i))) continue;
                    this.increasePointer();
                    return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
                }
            } else {
                this.increasePointer();
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<BlockPlacerTile> createEnergyStorage() {
        return new EnergyStorageComponent(BlockPlacerConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public BlockPlacerTile getSelf() {
        return this;
    }
}

