/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.misc.EnchantmentApplicatorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class EnchantmentApplicatorTile
extends IndustrialProcessingTile<EnchantmentApplicatorTile> {
    @Save
    private SidedInventoryComponent<EnchantmentApplicatorTile> inputFirst;
    @Save
    private SidedInventoryComponent<EnchantmentApplicatorTile> inputSecond;
    @Save
    private SidedInventoryComponent<EnchantmentApplicatorTile> output;
    @Save
    private SidedFluidTankComponent<EnchantmentApplicatorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", EnchantmentApplicatorConfig.tankSize, 34, 20, 0).setColor(DyeColor.LIME).setComponentHarness((IComponentHarness)this).setOnContentChange(() -> this.syncObject(this.tank)).setValidator(fluidStack -> TagUtil.hasTag((IForgeRegistry)ForgeRegistries.FLUIDS, (Object)fluidStack.getFluid(), IndustrialTags.Fluids.EXPERIENCE));

    public EnchantmentApplicatorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleMisc.ENCHANTMENT_APPLICATOR, 112, 40, blockPos, blockState);
        this.addTank(this.tank);
        this.inputFirst = (SidedInventoryComponent)new SidedInventoryComponent("inputFirst", 60, 40, 1, 1).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> !stack.getItem().equals(Items.ENCHANTED_BOOK)).setSlotLimit(1).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputFirst);
        this.inputSecond = (SidedInventoryComponent)new SidedInventoryComponent("inputSecond", 85, 40, 1, 2).setColor(DyeColor.MAGENTA).setSlotLimit(1).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputSecond);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 145, 40, 1, 3).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    public boolean canIncrease() {
        Pair<ItemStack, Integer> output = this.updateRepairOutput();
        long amount = this.tank.getFluidAmount();
        BlockEntity tileEntity = this.level.getBlockEntity(this.worldPosition.above());
        if (tileEntity != null && tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent()) {
            amount += (long)tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).filter(iFluidHandler -> iFluidHandler.getTanks() > 0 && TagUtil.hasTag((IForgeRegistry)ForgeRegistries.FLUIDS, (Object)iFluidHandler.getFluidInTank(0).getFluid(), IndustrialTags.Fluids.EXPERIENCE)).map(iFluidHandler -> iFluidHandler.getFluidInTank(0).getAmount()).orElse(0).intValue();
        }
        return !((ItemStack)output.getLeft()).isEmpty() && amount >= (long)this.getEssenceConsumed((Integer)output.getRight()) && this.output.getStackInSlot(0).isEmpty();
    }

    private int getEssenceConsumed(int experienceLevel) {
        long xp = 0L;
        if (experienceLevel >= 0 && experienceLevel <= 16) {
            xp = (long)(Math.pow(experienceLevel, 2.0) + (double)(6 * experienceLevel));
        }
        if (experienceLevel >= 17 && experienceLevel <= 31) {
            xp = (long)(2.5 * Math.pow(experienceLevel, 2.0) - 40.5 * (double)experienceLevel + 360.0);
        }
        if (experienceLevel >= 32) {
            xp = (long)(4.5 * Math.pow(experienceLevel, 2.0) - 162.5 * (double)experienceLevel + 2220.0);
        }
        return (xp *= 20L) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xp;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            Pair<ItemStack, Integer> output = this.updateRepairOutput();
            this.inputFirst.setStackInSlot(0, ItemStack.EMPTY);
            this.inputSecond.getStackInSlot(0).shrink(1);
            this.output.setStackInSlot(0, (ItemStack)output.getLeft());
            AtomicInteger amount = new AtomicInteger(this.getEssenceConsumed((Integer)output.getRight()));
            BlockEntity tileEntity = this.level.getBlockEntity(this.worldPosition.above());
            if (tileEntity != null) {
                tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(iFluidHandler -> amount.addAndGet(-iFluidHandler.drain(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), amount.get()), IFluidHandler.FluidAction.EXECUTE).getAmount()));
            }
            if (amount.get() > 0) {
                this.tank.drainForced(amount.get(), IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    protected int getTickPower() {
        return EnchantmentApplicatorConfig.powerPerTick;
    }

    public EnchantmentApplicatorTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<EnchantmentApplicatorTile> createEnergyStorage() {
        return new EnergyStorageComponent(EnchantmentApplicatorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return EnchantmentApplicatorConfig.maxProgress;
    }

    public Pair<ItemStack, Integer> updateRepairOutput() {
        ItemStack inputFirst = this.inputFirst.getStackInSlot(0);
        int maximumCost = 1;
        int i = 0;
        int j = 0;
        int k = 0;
        if (inputFirst.isEmpty()) {
            return Pair.of((Object)ItemStack.EMPTY, (Object)0);
        }
        ItemStack inputFirstCopy = inputFirst.copy();
        ItemStack inputSecond = this.inputSecond.getStackInSlot(0);
        Map map = EnchantmentHelper.getEnchantments((ItemStack)inputFirstCopy);
        j = j + inputFirst.getBaseRepairCost() + (inputSecond.isEmpty() ? 0 : inputSecond.getBaseRepairCost());
        boolean addEnchantment = false;
        if (!inputSecond.isEmpty()) {
            boolean bl = addEnchantment = inputSecond.getItem() == Items.ENCHANTED_BOOK && !EnchantedBookItem.getEnchantments((ItemStack)inputSecond).isEmpty();
            if (inputFirstCopy.isDamageableItem() && inputFirstCopy.getItem().isValidRepairItem(inputFirst, inputSecond)) {
                int l2 = Math.min(inputFirstCopy.getDamageValue(), inputFirstCopy.getMaxDamage() / 4);
                if (l2 <= 0) {
                    return Pair.of((Object)ItemStack.EMPTY, (Object)0);
                }
                for (int i3 = 0; l2 > 0 && i3 < inputSecond.getCount(); ++i3) {
                    int j3 = inputFirstCopy.getDamageValue() - l2;
                    inputFirstCopy.setDamageValue(j3);
                    ++i;
                    l2 = Math.min(inputFirstCopy.getDamageValue(), inputFirstCopy.getMaxDamage() / 4);
                }
            } else {
                if (!(addEnchantment || inputFirstCopy.getItem() == inputSecond.getItem() && inputFirstCopy.isDamageableItem())) {
                    return Pair.of((Object)ItemStack.EMPTY, (Object)0);
                }
                if (inputFirstCopy.isDamageableItem() && !addEnchantment) {
                    int l = inputFirst.getMaxDamage() - inputFirst.getDamageValue();
                    int i1 = inputSecond.getMaxDamage() - inputSecond.getDamageValue();
                    int j1 = i1 + inputFirstCopy.getMaxDamage() * 12 / 100;
                    int k1 = l + j1;
                    int l1 = inputFirstCopy.getMaxDamage() - k1;
                    if (l1 < 0) {
                        l1 = 0;
                    }
                    if (l1 < inputFirstCopy.getDamageValue()) {
                        inputFirstCopy.setDamageValue(l1);
                        i += 2;
                    }
                }
                Map map1 = EnchantmentHelper.getEnchantments((ItemStack)inputSecond);
                boolean flag2 = false;
                boolean flag3 = false;
                for (Enchantment enchantment1 : map1.keySet()) {
                    int j2;
                    if (enchantment1 == null) continue;
                    int enchantmentValue = map.getOrDefault(enchantment1, 0);
                    j2 = enchantmentValue == (j2 = ((Integer)map1.get(enchantment1)).intValue()) ? j2 + 1 : Math.max(j2, enchantmentValue);
                    boolean flag1 = enchantment1.canEnchant(inputFirst);
                    for (Enchantment enchantment : map.keySet()) {
                        if (enchantment == enchantment1 || enchantment1.isCompatibleWith(enchantment)) continue;
                        flag1 = false;
                        ++i;
                    }
                    if (!flag1) {
                        flag3 = true;
                        continue;
                    }
                    flag2 = true;
                    if (!EnchantmentApplicatorConfig.ignoreEnchantMaxLevels && j2 > enchantment1.getMaxLevel()) {
                        j2 = enchantment1.getMaxLevel();
                    }
                    map.put(enchantment1, j2);
                    int enchantmentRarity = 0;
                    switch (enchantment1.getRarity()) {
                        case COMMON: {
                            enchantmentRarity = 1;
                            break;
                        }
                        case UNCOMMON: {
                            enchantmentRarity = 2;
                            break;
                        }
                        case RARE: {
                            enchantmentRarity = 4;
                            break;
                        }
                        case VERY_RARE: {
                            enchantmentRarity = 8;
                        }
                    }
                    if (addEnchantment) {
                        enchantmentRarity = Math.max(1, enchantmentRarity / 2);
                    }
                    i += enchantmentRarity * j2;
                    if (inputFirst.getCount() <= 1) continue;
                    i = 40;
                }
                if (flag3 && !flag2) {
                    return Pair.of((Object)ItemStack.EMPTY, (Object)0);
                }
            }
        }
        if (addEnchantment && !inputFirstCopy.isBookEnchantable(inputSecond)) {
            inputFirstCopy = ItemStack.EMPTY;
        }
        maximumCost = j + i;
        if (i <= 0) {
            inputFirstCopy = ItemStack.EMPTY;
        }
        if (!inputFirstCopy.isEmpty()) {
            int repairCost = inputFirstCopy.getBaseRepairCost();
            if (!inputSecond.isEmpty() && repairCost < inputSecond.getBaseRepairCost()) {
                repairCost = inputSecond.getBaseRepairCost();
            }
            if (k != i || k == 0) {
                repairCost = AnvilMenu.calculateIncreasedRepairCost((int)repairCost);
            }
            inputFirstCopy.setRepairCost(repairCost);
            EnchantmentHelper.setEnchantments((Map)map, (ItemStack)inputFirstCopy);
        }
        return Pair.of((Object)inputFirstCopy, (Object)maximumCost);
    }
}

