/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class CrimedGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "crimed";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, integer) -> (Integer)this.calculate((ItemStack)stack).getLeft() > 0);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0;
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0) {
            ItemStack stack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).copy();
            ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).shrink(1);
            return this.calculate(stack);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.CYAN};
    }

    @Override
    public Item getDisplay() {
        return Items.WARPED_FUNGUS;
    }

    @Override
    public int getSlotSize() {
        return 64;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes() {
        ArrayList<MycelialGeneratorRecipe> recipes = new ArrayList<MycelialGeneratorRecipe>();
        for (Item item : new Item[]{Items.CRIMSON_FUNGUS, Items.CRIMSON_ROOTS, Items.WEEPING_VINES, Items.WARPED_FUNGUS, Items.WARPED_ROOTS, Items.NETHER_SPROUTS, Items.TWISTING_VINES, Items.SHROOMLIGHT, Items.NETHER_WART_BLOCK, Items.WARPED_WART_BLOCK}) {
            ItemStack stack = new ItemStack((ItemLike)item);
            Pair<Integer, Integer> power = this.calculate(stack);
            recipes.add(new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.of((ItemStack[])new ItemStack[]{stack}))), new ArrayList<List<FluidStack>>(), (Integer)power.getLeft(), (Integer)power.getRight()));
        }
        return recipes;
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.define(Character.valueOf('B'), (ItemLike)Blocks.NETHER_WART_BLOCK).define(Character.valueOf('C'), (ItemLike)Blocks.CRIMSON_FUNGUS).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        if (stack.getItem() == Items.CRIMSON_FUNGUS || stack.getItem() == Items.CRIMSON_ROOTS || stack.getItem() == Items.WEEPING_VINES || stack.getItem() == Items.WARPED_FUNGUS || stack.getItem() == Items.WARPED_ROOTS || stack.getItem() == Items.NETHER_SPROUTS || stack.getItem() == Items.TWISTING_VINES) {
            return Pair.of((Object)200, (Object)20);
        }
        if (stack.getItem() == Items.SHROOMLIGHT) {
            return Pair.of((Object)200, (Object)40);
        }
        if (stack.getItem() == Items.NETHER_WART_BLOCK || stack.getItem() == Items.WARPED_WART_BLOCK) {
            return Pair.of((Object)400, (Object)40);
        }
        return Pair.of((Object)0, (Object)80);
    }
}

