/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.transporter;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.RegulatorFilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.proxy.network.TransporterSyncMessage;
import com.hrznstudio.titanium.network.Message;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class FilteredTransporterType<TYPE, CAP>
extends TransporterType {
    private RegulatorFilter<TYPE, CAP> filter = this.createFilter();
    private boolean whitelist = false;
    private boolean isRegulated = false;

    public FilteredTransporterType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            if (compound.contains("Amount")) {
                this.filter.getFilter()[buttonId].increaseAmount(compound.getInt("Amount"));
            } else {
                this.filter.setFilter(buttonId, ItemStack.of((CompoundTag)compound));
            }
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 17) {
            this.isRegulated = !this.isRegulated;
            this.getContainer().requestSync();
        }
    }

    public abstract RegulatorFilter<TYPE, CAP> createFilter();

    @Override
    public void handleRenderSync(Direction origin, CompoundTag compoundNBT) {
    }

    @Override
    public void syncRender(Direction origin, CompoundTag compoundNBT) {
        IndustrialForegoing.NETWORK.sendToNearby(this.getLevel(), this.getPos(), 32, (Message)new TransporterSyncMessage(this.getPos(), compoundNBT, this.getSide().get3DDataValue(), origin.get3DDataValue()));
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add((IGuiComponent)new RegulatorFilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            public RegulatorFilter<TYPE, CAP> getFilter() {
                return FilteredTransporterType.this.filter;
            }

            public boolean isRegulator() {
                return FilteredTransporterType.this.isRegulated;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add((IGuiComponent)new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            public int getState() {
                return FilteredTransporterType.this.whitelist ? 0 : 1;
            }
        });
        componentList.add((IGuiComponent)new TexturedStateButtonGuiComponent(17, 133, 40, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 58, 233, new String[]{"regulated_true"}), new StateButtonInfo(1, res, 77, 233, new String[]{"regulated_false"})}){

            public int getState() {
                return FilteredTransporterType.this.isRegulated ? 0 : 1;
            }
        });
    }

    @Override
    public boolean ignoresCollision() {
        return false;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = super.serializeNBT();
        compoundNBT.put("Filter", (Tag)this.filter.serializeNBT());
        compoundNBT.putBoolean("Whitelist", this.whitelist);
        compoundNBT.putBoolean("Regulated", this.isRegulated);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (nbt.contains("Filter")) {
            this.filter.deserializeNBT(nbt.getCompound("Filter"));
        }
        this.whitelist = nbt.getBoolean("Whitelist");
        this.isRegulated = nbt.getBoolean("Regulated");
    }

    public RegulatorFilter<TYPE, CAP> getFilter() {
        return this.filter;
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public boolean isRegulated() {
        return this.isRegulated;
    }
}

