/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.render;

import com.buuz135.industrial.block.transportstorage.tile.BHTile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class BlackHoleUnitTESR
implements BlockEntityRenderer<BHTile> {
    public BlackHoleUnitTESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(BHTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getDisplayStack().isEmpty() && tile.shouldDisplay()) {
            ItemStack stack = tile.getDisplayStack();
            matrixStack.pushPose();
            Direction facing = tile.getFacingDirection();
            matrixStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
            if (facing == Direction.NORTH) {
                matrixStack.translate(-1.0f, 0.0f, 0.0f);
            }
            if (facing == Direction.EAST) {
                matrixStack.translate(-1.0f, 0.0f, -1.0f);
                matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            }
            if (facing == Direction.SOUTH) {
                matrixStack.translate(0.0f, 0.0f, -1.0f);
                matrixStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
            }
            if (facing == Direction.WEST) {
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            matrixStack.translate(0.5, 0.6, 0.0);
            if (stack.getItem() instanceof BlockItem) {
                matrixStack.scale(0.35f, 0.35f, 0.35f);
            } else {
                matrixStack.scale(0.4f, 0.4f, 0.4f);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, 0xF000F0, combinedOverlayIn, matrixStack, bufferIn, tile.getLevel(), 0);
            matrixStack.popPose();
            this.renderText(matrixStack, bufferIn, combinedOverlayIn, (Component)Component.literal((String)(ChatFormatting.WHITE + tile.getFormatedDisplayAmount())), facing, 0.015f);
        }
    }

    private void renderText(PoseStack matrix, MultiBufferSource renderer, int overlayLight, Component text, Direction side, float maxScale) {
        matrix.pushPose();
        matrix.translate(0.0, -0.3725, 0.0);
        switch (side) {
            case SOUTH: {
                matrix.translate(0.0, 1.0, 1.0E-4);
                matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case NORTH: {
                matrix.translate(1.0, 1.0, 0.9999);
                matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrix.translate(1.0E-4, 1.0, 1.0);
                matrix.mulPose(Axis.YP.rotationDegrees(90.0f));
                matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                matrix.translate(0.9999, 1.0, 0.0);
                matrix.mulPose(Axis.YP.rotationDegrees(-90.0f));
                matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
        }
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        matrix.translate(displayWidth / 2.0f, 1.0f, displayHeight / 2.0f);
        matrix.mulPose(Axis.XP.rotationDegrees(-90.0f));
        Font font = Minecraft.getInstance().font;
        int requiredWidth = Math.max(font.width((FormattedText)text), 1);
        Objects.requireNonNull(font);
        int requiredHeight = 9 + 2;
        float scaler = 0.4f;
        float scaleX = displayWidth / (float)requiredWidth;
        float scale = scaleX * scaler;
        if (maxScale > 0.0f) {
            scale = Math.min(scale, maxScale);
        }
        matrix.scale(scale, -scale, scale);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - requiredHeight) / 2;
        font.drawInBatch(text, (float)offsetX - (float)realWidth / 2.0f, (float)(3 + offsetY) - (float)realHeight / 2.0f, overlayLight, false, matrix.last().pose(), renderer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        matrix.popPose();
    }
}

