/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.event;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.item.ItemInfinityDrill;
import com.buuz135.industrial.module.ModuleTool;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.commons.lang3.tuple.Pair;

public class IFClientEvents {
    @SubscribeEvent
    public void blockOverlayEvent(RenderHighlightEvent.Block event) {
        BlockHitResult hit = event.getTarget();
        if (hit.getType() == HitResult.Type.BLOCK && Minecraft.getInstance().player.getMainHandItem().getItem().equals(ModuleTool.INFINITY_DRILL)) {
            BlockHitResult blockRayTraceResult = hit;
            event.setCanceled(true);
            ItemStack hand = Minecraft.getInstance().player.getMainHandItem();
            ItemInfinityDrill cfr_ignored_0 = (ItemInfinityDrill)ModuleTool.INFINITY_DRILL.get();
            InfinityTier tier = ItemInfinityDrill.getSelectedTier(hand);
            Level world = Minecraft.getInstance().player.getCommandSenderWorld();
            Pair<BlockPos, BlockPos> area = ((ItemInfinityDrill)ModuleTool.INFINITY_DRILL.get()).getArea(blockRayTraceResult.getBlockPos(), blockRayTraceResult.getDirection(), tier, false);
            PoseStack stack = new PoseStack();
            stack.pushPose();
            Camera info = event.getCamera();
            stack.mulPose(Axis.XP.rotationDegrees(info.getXRot()));
            stack.mulPose(Axis.YP.rotationDegrees(info.getYRot() + 180.0f));
            double d0 = info.getPosition().x();
            double d1 = info.getPosition().y();
            double d2 = info.getPosition().z();
            VertexConsumer builder = Minecraft.getInstance().renderBuffers().outlineBufferSource().getBuffer(RenderType.lines());
            BlockPos.betweenClosed((BlockPos)((BlockPos)area.getLeft()), (BlockPos)((BlockPos)area.getRight())).forEach(blockPos -> {
                VoxelShape shape = world.getBlockState(blockPos).getShape((BlockGetter)world, blockPos);
                if (!(shape == null || shape.isEmpty() || world.isEmptyBlock(blockPos) || !(world.getBlockState(blockPos).getDestroySpeed((BlockGetter)world, blockPos) >= 0.0f) || world.getBlockState(blockPos).getBlock() instanceof IFluidBlock || world.getBlockState(blockPos).getBlock() instanceof LiquidBlock)) {
                    LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)builder, (AABB)shape.bounds().move((double)blockPos.getX() - d0, (double)blockPos.getY() - d1, (double)blockPos.getZ() - d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
                }
            });
            stack.popPose();
        }
    }

    @SubscribeEvent
    public void onRenderPre(RenderPlayerEvent.Pre event) {
        if (event.getEntity().getUUID().equals(Minecraft.getInstance().player.getUUID()) && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
            return;
        }
        if (event.getEntity().getItemInHand(InteractionHand.MAIN_HAND).getItem().equals(ModuleTool.INFINITY_DRILL)) {
            event.getEntity().startUsingItem(InteractionHand.MAIN_HAND);
        } else if (event.getEntity().getItemInHand(InteractionHand.OFF_HAND).getItem().equals(ModuleTool.INFINITY_DRILL)) {
            event.getEntity().startUsingItem(InteractionHand.OFF_HAND);
        }
    }
}

