/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.machineproduce;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.plugin.jei.machineproduce.MachineProduceWrapper;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class MachineProduceCategory
implements IRecipeCategory<MachineProduceWrapper> {
    private IGuiHelper guiHelper;
    private final IDrawable smallTank;
    private final IDrawable icon;
    private final IDrawableStatic background;

    public MachineProduceCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.smallTank = guiHelper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 238, 4, 12, 13);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)((RegistryObject)ModuleCore.LATEX_PROCESSING.getKey()).get()));
        this.background = guiHelper.drawableBuilder(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 0, 54, 26).addPadding(0, 0, 0, 26).build();
    }

    public RecipeType<MachineProduceWrapper> getRecipeType() {
        return IndustrialRecipeTypes.MACHINE_PRODUCE;
    }

    public Component getTitle() {
        return Component.literal((String)"Machine Outputs");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MachineProduceWrapper recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addItemStack(new ItemStack((ItemLike)recipe.getBlock()))).setBackground((IDrawable)this.guiHelper.getSlotDrawable(), -1, -1);
        Ingredient outputItem = recipe.getOutputItem();
        if (outputItem == null) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 7).setFluidRenderer(1000L, false, 12, 13).setOverlay(this.smallTank, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid());
        } else {
            List<ItemStack> output = Arrays.asList((ItemStack[])outputItem.getItems().clone());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 57, 5).addItemStacks(output);
        }
    }

    public void draw(MachineProduceWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.getOutputItem() == null) {
            Screen screen = Minecraft.getInstance().screen;
            IAsset iAsset = DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL);
            Objects.requireNonNull(Minecraft.getInstance().font);
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)iAsset, (int)56, (int)(9 / 2));
        } else {
            Screen screen = Minecraft.getInstance().screen;
            Objects.requireNonNull(Minecraft.getInstance().font);
            SlotsScreenAddon.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)56, (int)(9 / 2), (int)0, (int)0, (int)1, integer -> Pair.of((Object)1, (Object)1), integer -> ItemStack.EMPTY, (boolean)true, integer -> new Color(DyeColor.ORANGE.getFireworkColor()), integer -> true, (int)1);
        }
    }
}

