/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.api.IMachineSettings;
import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MachineSettingCopier
extends IFCustomItem {
    public MachineSettingCopier(TitaniumTab tab) {
        super("machine_settings_copier", tab, new Item.Properties().stacksTo(1));
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PLP").pattern("LRL").pattern("PRP").define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('L'), IndustrialTags.Items.PLASTIC).save(consumer);
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (stack.hasTag()) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.machine_settings_copier.settings_stored").withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.machine_settings_copier.settings_clear").withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.machine_settings_copier.settings_can_copy").withStyle(ChatFormatting.GRAY));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity tile = context.getLevel().getBlockEntity(context.getClickedPos());
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (tile instanceof IMachineSettings) {
            IMachineSettings machineSettings = (IMachineSettings)tile;
            if (stack.hasTag()) {
                if (!context.getLevel().isClientSide()) {
                    machineSettings.loadSettings(player, stack.getTag());
                }
                player.playSound(SoundEvents.ANVIL_USE, 0.1f, 1.0f);
                player.displayClientMessage((Component)Component.translatable((String)"text.industrialforegoing.machine_settings_copier.settings_stored"), true);
                return InteractionResult.SUCCESS;
            }
            if (!context.getLevel().isClientSide()) {
                CompoundTag tag = new CompoundTag();
                machineSettings.saveSettings(player, tag);
                stack.setTag(tag);
            }
            player.playSound(SoundEvents.ARROW_HIT_PLAYER, 0.5f, 1.0f);
            player.displayClientMessage((Component)Component.translatable((String)"text.industrialforegoing.machine_settings_copier.settings_copied"), true);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level p_41432_, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown() && player.getItemInHand(hand).hasTag()) {
            player.getItemInHand(hand).setTag(null);
            player.playSound(SoundEvents.FIRE_EXTINGUISH, 0.5f, 1.0f);
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        return super.use(p_41432_, player, hand);
    }
}

