/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.conveyor;

import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ObjectHolder;

public class ContainerConveyor
extends AbstractContainerMenu {
    @ObjectHolder(value="industrialforegoing:conveyor", registryName="minecraft:menu")
    public static MenuType<ContainerConveyor> TYPE;
    private final ConveyorTile conveyor;
    private Direction facing;

    public ContainerConveyor(int id, Inventory player, FriendlyByteBuf buffer) {
        this(id, (ConveyorTile)player.player.getCommandSenderWorld().getBlockEntity(buffer.readBlockPos()), (Direction)buffer.readEnum(Direction.class), player);
    }

    public ContainerConveyor(int id, ConveyorTile conveyor, Direction facing, Inventory player) {
        super(TYPE, id);
        this.conveyor = conveyor;
        this.facing = facing;
        if (!conveyor.hasUpgrade(facing) && conveyor.getUpgradeMap().size() > 0) {
            this.facing = conveyor.getUpgradeMap().keySet().iterator().next();
        }
        this.createPlayerInventory(player);
    }

    private void createPlayerInventory(Inventory player) {
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)player, k, 8 + k * 18, 142));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ConveyorTile getConveyor() {
        return this.conveyor;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }
}

