/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.buuz135.industrial.utils.NumberUtils;
import com.buuz135.industrial.worlddata.BackpackDataManager;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public abstract class SlotDefinitionGuiAddon
extends BasicButtonAddon {
    private int slotId;

    public SlotDefinitionGuiAddon(ButtonComponent buttonComponent, int slotId) {
        super(buttonComponent);
        this.slotId = slotId;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (!this.getItemStack().isEmpty() && this.getItemStack().hasTag()) {
            BackpackDataManager.SlotDefinition display;
            BackpackDataManager.BackpackItemHandler handler = BackpackDataManager.CLIENT_SIDE_BACKPACKS.getOrDefault(this.getItemStack().getTag().getString("Id"), null);
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.SLOT), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
            if (handler != null && !(display = handler.getSlotDefinition(this.slotId)).getStack().isEmpty()) {
                guiGraphics.renderItem(display.getStack(), guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 260.0f);
                guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                String amount = NumberUtils.getFormatedBigNumber(display.getAmount());
                guiGraphics.drawString(Minecraft.getInstance().font, amount, (int)(((float)(guiX + this.getPosX() + 17) - (float)Minecraft.getInstance().font.width(amount) / 2.0f) * 2.0f), (guiY + this.getPosY() + 13) * 2, 0xFFFFFF, true);
                guiGraphics.pose().popPose();
            }
        }
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX - guiX, mouseY - guiY)) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 256.0f);
            AssetUtil.drawSelectingOverlay((GuiGraphics)guiGraphics, (int)(this.getPosX() + 1), (int)(this.getPosY() + 1), (int)(this.getPosX() + this.getXSize() - 1), (int)(this.getPosY() + this.getYSize() - 1));
            guiGraphics.pose().popPose();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen && ((AbstractContainerScreen)screen).getMenu() instanceof ILocatable) {
            if (!this.isMouseOver(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            ILocatable locatable = (ILocatable)((AbstractContainerScreen)screen).getMenu();
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.putString("Id", this.getItemStack().getTag().getString("Id"));
            compoundNBT.putInt("Slot", this.slotId);
            compoundNBT.putInt("Button", button);
            compoundNBT.putBoolean("Shift", Screen.hasShiftDown());
            compoundNBT.putBoolean("Ctrl", Screen.hasControlDown());
            Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), 4, compoundNBT));
            return true;
        }
        return false;
    }

    public abstract ItemStack getItemStack();

    public List<Component> getTooltipLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        BackpackDataManager.BackpackItemHandler handler = BackpackDataManager.CLIENT_SIDE_BACKPACKS.getOrDefault(this.getItemStack().getTag().getString("Id"), null);
        if (handler != null) {
            BackpackDataManager.SlotDefinition display = handler.getSlotDefinition(this.slotId);
            if (!display.getStack().isEmpty()) {
                Screen cfr_ignored_0 = Minecraft.getInstance().screen;
                lines.addAll(Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)display.getStack()));
                lines.add((Component)Component.literal((String)(ChatFormatting.GOLD + new DecimalFormat().format(display.getAmount()))));
            }
            String changeVoid = ChatFormatting.DARK_GRAY + Component.translatable((String)"text.industrialforegoing.tooltip.ctrl_left").getString();
            if (display.isVoidItems()) {
                lines.add((Component)Component.literal((String)(ChatFormatting.GOLD + Component.translatable((String)"tooltip.industrialforegoing.backpack.void").getString() + ChatFormatting.GREEN + Component.translatable((String)"text.industrialforegoing.display.enabled").getString() + " " + changeVoid)));
            } else {
                lines.add((Component)Component.literal((String)(ChatFormatting.GOLD + Component.translatable((String)"tooltip.industrialforegoing.backpack.void").getString() + ChatFormatting.RED + Component.translatable((String)"text.industrialforegoing.display.disabled").getString() + " " + changeVoid)));
            }
            String changeRefill = ChatFormatting.DARK_GRAY + Component.translatable((String)"text.industrialforegoing.tooltip.ctrl_right").getString();
            if (display.isRefillItems()) {
                lines.add((Component)Component.literal((String)(ChatFormatting.GOLD + Component.translatable((String)"tooltip.industrialforegoing.backpack.refill").getString() + ChatFormatting.GREEN + Component.translatable((String)"text.industrialforegoing.display.enabled").getString() + " " + changeRefill)));
            } else {
                lines.add((Component)Component.literal((String)(ChatFormatting.GOLD + Component.translatable((String)"tooltip.industrialforegoing.backpack.refill").getString() + ChatFormatting.RED + Component.translatable((String)"text.industrialforegoing.display.disabled").getString() + " " + changeRefill)));
            }
        }
        return lines;
    }
}

