/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.block.transportstorage.BlackHoleTankBlock;
import com.buuz135.industrial.block.transportstorage.BlackHoleUnitBlock;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryObject;

public class BlackHoleControllerTile
extends ActiveTile<BlackHoleControllerTile> {
    @Save
    private InventoryComponent<BlackHoleControllerTile> units_storage = new InventoryComponent("units_storage", 53, 20, 16).setSlotLimit(1).setInputFilter((itemStack, integer) -> itemStack.getItem() instanceof BlackHoleTankBlock.BlackHoleTankItem || itemStack.getItem() instanceof BlackHoleUnitBlock.BlackHoleUnitItem).setOutputFilter((itemStack, integer) -> false).setRange(4, 4);
    private BlackHoleControllerInventory inventory;
    private BlackHoleControllerTank tank;
    private LazyOptional<BlackHoleControllerInventory> lazyInventory;
    private LazyOptional<BlackHoleControllerTank> lazyTank;

    public BlackHoleControllerTile(BlockPos blockPos, BlockState blockState) {
        super((BasicTileBlock)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_CONTROLLER.getLeft()).get(), (BlockEntityType)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_CONTROLLER.getRight()).get(), blockPos, blockState);
        this.addInventory(this.units_storage);
        for (int i = 0; i < this.units_storage.getSlots(); ++i) {
            this.units_storage.setSlotToColorRender(i, DyeColor.BLUE);
        }
        this.inventory = new BlackHoleControllerInventory();
        this.tank = new BlackHoleControllerTank();
        this.lazyInventory = LazyOptional.of(() -> this.inventory);
        this.lazyTank = LazyOptional.of(() -> this.tank);
    }

    @Nonnull
    public BlackHoleControllerTile getSelf() {
        return this;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyInventory.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyTank.cast();
        }
        return super.getCapability(cap, side);
    }

    public InteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        this.openGui(playerIn);
        return InteractionResult.SUCCESS;
    }

    public InventoryComponent<BlackHoleControllerTile> getUnitsStorage() {
        return this.units_storage;
    }

    private class BlackHoleControllerInventory
    implements IItemHandler {
        private BlackHoleControllerInventory() {
        }

        public int getSlots() {
            return 16;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(slot);
            if (!bl.isEmpty() && bl.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                IItemHandler handler = (IItemHandler)bl.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
                return handler.getStackInSlot(0);
            }
            return ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(slot);
            if (!bl.isEmpty() && bl.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                IItemHandler handler = (IItemHandler)bl.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
                return handler.insertItem(0, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(slot);
            if (!bl.isEmpty() && bl.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                IItemHandler handler = (IItemHandler)bl.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
                return handler.extractItem(0, amount, simulate);
            }
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(slot);
            if (!bl.isEmpty() && bl.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                IItemHandler handler = (IItemHandler)bl.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
                return handler.getSlotLimit(0);
            }
            return 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(slot);
            if (!bl.isEmpty() && bl.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                IItemHandler handler = (IItemHandler)bl.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
                return handler.isItemValid(0, stack);
            }
            return false;
        }
    }

    private class BlackHoleControllerTank
    implements IFluidHandler {
        private BlackHoleControllerTank() {
        }

        public int getTanks() {
            return 16;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(tank);
            if (!bl.isEmpty() && bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
                IFluidHandler handler = (IFluidHandler)bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                return handler.getFluidInTank(0);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(tank);
            if (!bl.isEmpty() && bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
                IFluidHandler handler = (IFluidHandler)bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                return handler.getTankCapacity(0);
            }
            return 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(tank);
            if (!bl.isEmpty() && bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
                IFluidHandler handler = (IFluidHandler)bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                return handler.isFluidValid(0, stack);
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (int i = 0; i < this.getTanks(); ++i) {
                IFluidHandler handler;
                int amount;
                ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(i);
                if (bl.isEmpty() || !bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() || (amount = (handler = (IFluidHandler)bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null)).fill(resource, action)) <= 0) continue;
                return amount;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (int i = 0; i < this.getTanks(); ++i) {
                IFluidHandlerItem handler;
                FluidStack fluid;
                ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(i);
                if (bl.isEmpty() || !bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() || (fluid = (handler = (IFluidHandlerItem)bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null)).drain(resource, action)).isEmpty()) continue;
                if (handler.getFluidInTank(0).isEmpty()) {
                    BlackHoleControllerTile.this.units_storage.setStackInSlot(i, handler.getContainer());
                }
                return fluid;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (int i = 0; i < this.getTanks(); ++i) {
                IFluidHandlerItem handler;
                FluidStack fluid;
                ItemStack bl = BlackHoleControllerTile.this.units_storage.getStackInSlot(i);
                if (bl.isEmpty() || !bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() || (fluid = (handler = (IFluidHandlerItem)bl.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null)).drain(maxDrain, action)).isEmpty()) continue;
                if (handler.getFluidInTank(0).isEmpty()) {
                    BlackHoleControllerTile.this.units_storage.setStackInSlot(i, handler.getContainer());
                }
                return fluid;
            }
            return FluidStack.EMPTY;
        }
    }
}

