/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.SewerConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SewerTile
extends IndustrialAreaWorkingTile<SewerTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    public SidedFluidTankComponent<SewerTile> sewage = (SidedFluidTankComponent)new SidedFluidTankComponent("sewage", SewerConfig.maxSewageTankSize, 45, 20, 0).setColor(DyeColor.BROWN).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this);
    @Save
    public SidedFluidTankComponent<SewerTile> essence;

    public SewerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.SEWER, RangeManager.RangeType.TOP, true, SewerConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.sewage);
        this.essence = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", SewerConfig.maxEssenceTankSize, 66, 20, 1).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this);
        this.addTank(this.essence);
        this.maxProgress = SewerConfig.maxProgress;
        this.powerPerOperation = SewerConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        List entities = this.level.getEntitiesOfClass(Animal.class, this.getWorkingArea().bounds());
        int amount = entities.size();
        if (amount > 0 && this.hasEnergy(this.powerPerOperation * amount)) {
            this.sewage.fillForced(new FluidStack((Fluid)ModuleCore.SEWAGE.getSourceFluid().get(), 50 * amount), IFluidHandler.FluidAction.EXECUTE);
            ++amount;
        }
        List orb = this.level.getEntitiesOfClass(ExperienceOrb.class, this.getWorkingArea().bounds());
        for (ExperienceOrb experienceOrbEntity : orb) {
            if (!experienceOrbEntity.isAlive() || this.essence.getFluidAmount() + experienceOrbEntity.value * 20 > this.essence.getCapacity()) continue;
            this.essence.fillForced(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), experienceOrbEntity.value * 20), IFluidHandler.FluidAction.EXECUTE);
            experienceOrbEntity.remove(Entity.RemovalReason.KILLED);
        }
        List playerList = this.level.getEntitiesOfClass(Player.class, this.getWorkingArea().bounds());
        for (Player player : playerList) {
            int fluidSpace = this.essence.getCapacity() - this.essence.getFluidAmount();
            int toExtractEssence = Math.min(fluidSpace, player.totalExperience * 20);
            player.giveExperiencePoints(toExtractEssence / -20);
            this.essence.fillForced(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), toExtractEssence), IFluidHandler.FluidAction.EXECUTE);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.powerPerOperation * amount);
    }

    protected EnergyStorageComponent<SewerTile> createEnergyStorage() {
        return new EnergyStorageComponent(SewerConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public SewerTile getSelf() {
        return this;
    }
}

