/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.capability.tile.BigEnergyHandler;
import com.buuz135.industrial.config.machine.agriculturehusbandry.MobDuplicatorConfig;
import com.buuz135.industrial.item.MobImprisonmentToolItem;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class MobDuplicatorTile
extends IndustrialAreaWorkingTile<MobDuplicatorTile> {
    private int maxProgress;
    private int powerPerOperation;
    private boolean exactCopy;
    @Save
    private SidedFluidTankComponent<MobDuplicatorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", MobDuplicatorConfig.tankSize, 43, 20, 0).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> ForgeRegistries.FLUIDS.tags().getTag(IndustrialTags.Fluids.EXPERIENCE).contains((Object)fluidStack.getFluid()));
    @Save
    private SidedInventoryComponent<MobDuplicatorTile> input;

    public MobDuplicatorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.MOB_DUPLICATOR, RangeManager.RangeType.TOP_UP, true, MobDuplicatorConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.tank);
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("mob_imprisonment_tool", 64, 22, 1, 1).setColor(DyeColor.ORANGE).setInputFilter((itemStack, integer) -> itemStack.getItem().equals(ModuleTool.MOB_IMPRISONMENT_TOOL.get())).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.input);
        this.maxProgress = MobDuplicatorConfig.maxProgress;
        this.powerPerOperation = MobDuplicatorConfig.powerPerOperation;
        this.exactCopy = MobDuplicatorConfig.exactCopy;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.input.getStackInSlot(0).isEmpty() || !this.hasEnergy(MobDuplicatorConfig.powerPerOperation)) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        if (this.tank.getFluid().isEmpty()) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        ItemStack stack = this.input.getStackInSlot(0);
        LivingEntity entity = (LivingEntity)((MobImprisonmentToolItem)stack.getItem()).getEntityFromStack(stack, this.level, MobDuplicatorConfig.exactCopy && this.exactCopy, true);
        if (entity == null) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        List entityAmount = this.level.getEntitiesOfClass(entity.getClass(), this.getWorkingArea().bounds());
        entityAmount.removeIf(entityLiving -> !entityLiving.isAlive());
        if (entityAmount.size() > 32) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        int essenceNeeded = (int)(entity.getHealth() * (float)MobDuplicatorConfig.essenceNeeded);
        int canSpawn = (this.tank.getFluid().isEmpty() ? 0 : this.tank.getFluid().getAmount()) / Math.max(essenceNeeded, 1);
        if (canSpawn == 0) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        int spawnAmount = 1 + this.level.random.nextInt(Math.min(canSpawn, 4));
        List<BlockPos> blocks = BlockUtils.getBlockPosInAABB(this.getWorkingArea().bounds());
        while (spawnAmount > 0) {
            if (this.tank.getFluid().getAmount() >= essenceNeeded) {
                entity = (LivingEntity)((MobImprisonmentToolItem)stack.getItem()).getEntityFromStack(stack, this.level, MobDuplicatorConfig.exactCopy && this.exactCopy, true);
                int tries = 20;
                Vec3 random = this.blockPosToVec3d(blocks.get(this.level.random.nextInt(blocks.size())));
                random = random.add(0.5, 0.0, 0.5);
                entity.moveTo(random.x, random.y, random.z, this.level.random.nextFloat() * 360.0f, 0.0f);
                entity.setUUID(UUID.randomUUID());
                if (entity instanceof Mob) {
                    ((Mob)entity).finalizeSpawn((ServerLevelAccessor)this.level, this.level.getCurrentDifficultyAt(this.worldPosition), MobSpawnType.MOB_SUMMONED, null, null);
                }
                while (tries > 0 && !this.canEntitySpawn(entity)) {
                    random = this.blockPosToVec3d(blocks.get(this.level.random.nextInt(blocks.size())));
                    random = random.add(0.5, 0.0, 0.5);
                    entity.moveTo(random.x, random.y, random.z, this.level.random.nextFloat() * 360.0f, 0.0f);
                    --tries;
                }
                if (tries <= 0) {
                    --spawnAmount;
                    continue;
                }
                this.level.addFreshEntity((Entity)entity);
                this.tank.drainForced(essenceNeeded, IFluidHandler.FluidAction.EXECUTE);
            }
            --spawnAmount;
        }
        if (canSpawn > 0) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, MobDuplicatorConfig.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private boolean canEntitySpawn(LivingEntity living) {
        return this.level.isUnobstructed((Entity)living) && !this.level.containsAnyLiquid(living.getBoundingBox());
    }

    private Vec3 blockPosToVec3d(BlockPos blockPos) {
        return new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this.worldPosition, this.getFacingDirection(), RangeManager.RangeType.TOP_UP){

            @Override
            public AABB getBox() {
                return super.getBox().expandTowards(0.0, 1.0, 0.0);
            }
        }.get(this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)), (IAugmentType)RangeAddonItem.RANGE) + 1 : 0);
    }

    @Nonnull
    public MobDuplicatorTile getSelf() {
        return this;
    }

    @Nonnull
    protected EnergyStorageComponent<MobDuplicatorTile> createEnergyStorage() {
        return new BigEnergyHandler<MobDuplicatorTile>(MobDuplicatorConfig.maxStoredPower, 10, 20){

            @Override
            public void sync() {
                MobDuplicatorTile.this.syncObject(MobDuplicatorTile.this.getEnergyStorage());
            }
        };
    }

    @Override
    public int getMaxProgress() {
        return MobDuplicatorConfig.maxProgress;
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putBoolean("MC_exactCopy", this.exactCopy);
        super.saveSettings(player, tag);
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("MC_exactCopy")) {
            this.exactCopy = tag.getBoolean("MC_exactCopy");
        }
        super.loadSettings(player, tag);
    }
}

