/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.data;

import com.blamejared.wac.block.BookStackBlock;
import com.blamejared.wac.block.WACBlocks;
import com.blamejared.wac.registry.RegistryObject;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class WACBlockLoot
extends BlockLootSubProvider {
    private final Set<Block> knownBlocks = new ReferenceOpenHashSet();

    public WACBlockLoot(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        List<RegistryObject> dropsSelf = List.of(WACBlocks.MOSSY_PODIUM, WACBlocks.WILTED_LOG, WACBlocks.STRIPPED_WILTED_WOOD, WACBlocks.STRIPPED_WILTED_WOOD, WACBlocks.WILTED_PLANKS, WACBlocks.WILTED_WOOD, WACBlocks.WILTED_SIGN, WACBlocks.WILTED_HANGING_SIGN, WACBlocks.WILTED_DOOR, WACBlocks.WILTED_STAIRS, WACBlocks.WILTED_PRESSURE_PLATE, WACBlocks.WILTED_FENCE, WACBlocks.WILTED_TRAPDOOR, WACBlocks.WILTED_FENCE_GATE, WACBlocks.WILTED_BUTTON, WACBlocks.WILTED_SAPLING, WACBlocks.WILTED_SLAB, WACBlocks.WILTED_SHELF, WACBlocks.WITCHY_DECOR, WACBlocks.WILTED_ALLIUM, WACBlocks.WILTED_DANDELION, WACBlocks.WILTED_LILY, WACBlocks.WILTED_ORCHID, WACBlocks.WILTED_ROSE, WACBlocks.DEEPSLATE_BASIN);
        for (RegistryObject entry : dropsSelf) {
            this.dropSelf((Block)entry.get());
        }
        this.add((Block)WACBlocks.WILTED_LEAVES.get(), block -> this.createOakLeavesDrops((Block)block, (Block)WACBlocks.WILTED_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(WACBlocks.WILTED_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
        this.add(WACBlocks.BOOK_STACK.get(), this::createBookStack);
    }

    protected void add(Block block, LootTable.Builder table) {
        super.add(block, table);
        this.knownBlocks.add(block);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected LootTable.Builder createBookStack(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, LootItem.lootTableItem((ItemLike)block).apply(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), num -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)num.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BookStackBlock.BOOKS, num.intValue())))))));
    }
}

