/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.block.entity;

import com.blamejared.wac.block.entity.WACBlockEntityTypes;
import com.blamejared.wac.recipe.WACRecipes;
import com.blamejared.wac.recipe.ritual.Ritual;
import com.blamejared.wac.recipe.ritual.RitualRecipeInput;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DeepslateBasinBlockEntity
extends BlockEntity
implements WorldlyContainer {
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final RecipeManager.CachedCheck<RitualRecipeInput, Ritual> quickCheck = RecipeManager.createCheck(WACRecipes.RITUAL_TYPE.get());

    public DeepslateBasinBlockEntity(BlockPos pos, BlockState blockState) {
        super(WACBlockEntityTypes.DEEPSLATE_BASIN.get(), pos, blockState);
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return direction == Direction.UP;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return direction == Direction.DOWN;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isFull() {
        for (ItemStack item : this.items) {
            if (!item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Optional<RecipeHolder<Ritual>> checkRecipe(Player player, int enchantmentPower) {
        return this.quickCheck.getRecipeFor((RecipeInput)new RitualRecipeInput(this.items, player, enchantmentPower), this.level);
    }

    public void addItem(ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.getItem(i).isEmpty()) continue;
            this.setItem(i, stack);
            return;
        }
    }

    public ItemStack removeItem() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (this.getItem(i).isEmpty()) continue;
            return this.removeItem(i, 1);
        }
        return ItemStack.EMPTY;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public NonNullList<ItemStack> items() {
        return this.items;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag updateTag = super.getUpdateTag(registries);
        ContainerHelper.saveAllItems((CompoundTag)updateTag, this.items, (HolderLookup.Provider)registries);
        return updateTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

