/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.block;

import com.blamejared.wac.block.entity.DeepslateBasinBlockEntity;
import com.blamejared.wac.recipe.ritual.Ritual;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DeepslateBasin
extends BaseEntityBlock {
    public static final MapCodec<DeepslateBasin> CODEC = DeepslateBasin.simpleCodec(DeepslateBasin::new);
    protected static final VoxelShape SHAPE = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)DeepslateBasin.box((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final List<BlockPos> BOOKSHELF_OFFSETS = BlockPos.betweenClosedStream((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(p_341357_ -> Math.abs(p_341357_.getX()) == 2 || Math.abs(p_341357_.getZ()) == 2).map(BlockPos::immutable).toList();

    public DeepslateBasin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DeepslateBasinBlockEntity) {
            DeepslateBasinBlockEntity be = (DeepslateBasinBlockEntity)blockEntity;
            if (!stack.isEmpty() && !be.isFull()) {
                be.addItem(stack.split(1));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DeepslateBasinBlockEntity) {
            DeepslateBasinBlockEntity be = (DeepslateBasinBlockEntity)blockEntity;
            if (player.isShiftKeyDown()) {
                if (!be.isEmpty() && !be.isEmpty()) {
                    ItemStack itemStack = be.removeItem();
                    if (!player.getInventory().add(itemStack)) {
                        player.drop(itemStack, false);
                    }
                    be.setChanged();
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else {
                int enchantmentPower = 0;
                for (BlockPos blockpos : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
                    if (!DeepslateBasin.isValidBookShelf(level, pos, blockpos)) continue;
                    ++enchantmentPower;
                }
                Optional<RecipeHolder<Ritual>> recipe = be.checkRecipe(player, enchantmentPower);
                if (recipe.isPresent()) {
                    RecipeHolder<Ritual> ritualRecipeHolder = recipe.get();
                    Ritual value = (Ritual)ritualRecipeHolder.value();
                    player.addEffect(value.output());
                    be.clearContent();
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return InteractionResult.PASS;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            DeepslateBasinBlockEntity be;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof DeepslateBasinBlockEntity && !(be = (DeepslateBasinBlockEntity)blockEntity).isEmpty()) {
                for (ItemStack item : be.items()) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)item);
                }
                be.clearContent();
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    public static boolean isValidBookShelf(Level level, BlockPos enchantingTablePos, BlockPos bookshelfPos) {
        return level.getBlockState(enchantingTablePos.offset((Vec3i)bookshelfPos)).is(BlockTags.ENCHANTMENT_POWER_PROVIDER) && level.getBlockState(enchantingTablePos.offset(bookshelfPos.getX() / 2, bookshelfPos.getY(), bookshelfPos.getZ() / 2)).is(BlockTags.ENCHANTMENT_POWER_TRANSMITTER);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        for (BlockPos blockpos : BOOKSHELF_OFFSETS) {
            if (random.nextInt(16) != 0 || !DeepslateBasin.isValidBookShelf(level, pos, blockpos)) continue;
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)blockpos.getX() + random.nextFloat()) - 0.5, (double)((float)blockpos.getY() - random.nextFloat() - 1.0f), (double)((float)blockpos.getZ() + random.nextFloat()) - 0.5);
        }
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DeepslateBasinBlockEntity(pos, state);
    }

    public MapCodec<DeepslateBasin> codec() {
        return CODEC;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

