/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.slimyboyos.mixin.common;

import com.blamejared.slimyboyos.Constants;
import com.blamejared.slimyboyos.api.IAbsorber;
import com.blamejared.slimyboyos.platform.Services;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity
implements IAbsorber {
    @Unique
    private static final EntityDataAccessor<ItemStack> DATA_ABSORBED = SynchedEntityData.defineId(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    @Unique
    public boolean slimyboyos$canAbsorb;

    @Shadow
    public abstract boolean isAlive();

    public MixinLivingEntity(EntityType<?> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void slimyboyos$defineSyncedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(DATA_ABSORBED, (Object)ItemStack.EMPTY);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void slimyboyos$tick(CallbackInfo ci) {
        block7: {
            block6: {
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block6;
                ServerLevel sl = (ServerLevel)level;
                if (this.isAlive() && sl.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) break block7;
            }
            return;
        }
        if (this.tickCount % 20 == 0) {
            this.slimyboyos$canAbsorb = this.getType().is(Services.PLATFORM.getSlimeTag());
        }
        if (this.slimyboyos$canAbsorb) {
            if (!this.slimyboyos$getAbsorbedItem().isEmpty()) {
                return;
            }
            AABB boundingBox = this.getBoundingBox();
            List entities = this.level().getEntities((EntityTypeTest)EntityType.ITEM, boundingBox, item -> item.isAlive() && !item.isPickable() && !item.getItem().isEmpty());
            entities.stream().filter(item -> !item.getItem().is(Constants.SLIMES_CANNOT_ABSORB.get())).findFirst().ifPresent(item -> {
                ItemStack stack = item.getItem();
                ItemStack absorbedStack = stack.split(1);
                this.slimyboyos$setAbsorbedItem(absorbedStack);
                if (stack.isEmpty()) {
                    item.discard();
                }
            });
        }
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="TAIL")})
    public void slimyboyos$dropCustomDeathLoot(ServerLevel level, DamageSource $$1, CallbackInfo ci) {
        ServerLevel sl;
        block5: {
            block4: {
                Level level2 = this.level();
                if (!(level2 instanceof ServerLevel)) break block4;
                sl = (ServerLevel)level2;
                if (level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) break block5;
            }
            return;
        }
        ItemStack stack = this.slimyboyos$getAbsorbedItem();
        if (!stack.isEmpty()) {
            this.spawnAtLocation(sl, stack);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void slimyboyos$save(ValueOutput value, CallbackInfo ci) {
        if (!this.slimyboyos$getAbsorbedItem().isEmpty()) {
            value.store("slimyboyos:absorbed_item", ItemStack.CODEC, (Object)this.slimyboyos$getAbsorbedItem());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void slimyboyos$load(ValueInput value, CallbackInfo ci) {
        value.read("slimyboyos:absorbed_item", ItemStack.CODEC).ifPresent(this::slimyboyos$setAbsorbedItem);
    }

    @Override
    public ItemStack slimyboyos$getAbsorbedItem() {
        return (ItemStack)this.entityData.get(DATA_ABSORBED);
    }

    @Override
    public void slimyboyos$setAbsorbedItem(ItemStack stack) {
        this.entityData.set(DATA_ABSORBED, (Object)stack);
    }
}

