/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.formatter;

import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.TokenRange;
import com.blamejared.searchables.api.formatter.FormattingConstants;
import com.blamejared.searchables.api.formatter.FormattingContext;
import com.blamejared.searchables.lang.StringSearcher;
import com.blamejared.searchables.lang.expression.type.ComponentExpression;
import com.blamejared.searchables.lang.expression.type.GroupingExpression;
import com.blamejared.searchables.lang.expression.type.LiteralExpression;
import com.blamejared.searchables.lang.expression.type.PairedExpression;
import com.blamejared.searchables.lang.expression.visitor.ContextAwareVisitor;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class FormattingVisitor
implements ContextAwareVisitor<TokenRange, FormattingContext>,
Consumer<String>,
EditBox.TextFormatter {
    private final SearchableType<?> type;
    private final List<Pair<TokenRange, Style>> tokens = new ArrayList<Pair<TokenRange, Style>>();
    private TokenRange lastRange = TokenRange.at(0);

    public FormattingVisitor(SearchableType<?> type) {
        this.type = type;
    }

    public void reset() {
        this.tokens.clear();
        this.lastRange = TokenRange.at(0);
    }

    public List<Pair<TokenRange, Style>> tokens() {
        return this.tokens;
    }

    public Optional<Pair<TokenRange, Style>> tokenAt(int position) {
        return this.tokens.stream().filter(range -> ((TokenRange)range.getFirst()).contains(position)).findFirst();
    }

    @Override
    public TokenRange visitGrouping(GroupingExpression expr, FormattingContext context) {
        TokenRange leftRange = expr.left().accept(this, context);
        this.tokens.add((Pair<TokenRange, Style>)Pair.of((Object)this.getAndPushRange(), (Object)context.style()));
        TokenRange rightRange = expr.right().accept(this, context);
        return TokenRange.encompassing(leftRange, rightRange);
    }

    @Override
    public TokenRange visitComponent(ComponentExpression expr, FormattingContext context) {
        boolean valid = context.valid() && expr.left() instanceof LiteralExpression && expr.right() instanceof LiteralExpression;
        TokenRange leftRange = expr.left().accept(this, FormattingContext.key(FormattingConstants.KEY, valid));
        this.tokens.add((Pair<TokenRange, Style>)Pair.of((Object)this.getAndPushRange(), (Object)context.style(valid)));
        TokenRange rightRange = expr.right().accept(this, FormattingContext.literal(FormattingConstants.TERM, valid));
        return TokenRange.encompassing(leftRange, rightRange);
    }

    @Override
    public TokenRange visitLiteral(LiteralExpression expr, FormattingContext context) {
        Style style = context.style();
        if (!context.valid() || context.isKey() && !this.type.components().containsKey(expr.value())) {
            style = FormattingConstants.INVALID;
        }
        TokenRange range = this.getAndPushRange(expr.displayValue().length());
        this.tokens.add((Pair<TokenRange, Style>)Pair.of((Object)range, (Object)style));
        return range;
    }

    @Override
    public TokenRange visitPaired(PairedExpression expr, FormattingContext context) {
        TokenRange leftRange = expr.first().accept(this, context);
        TokenRange rightRange = expr.second().accept(this, context);
        return TokenRange.encompassing(leftRange, rightRange);
    }

    private TokenRange getAndPushRange() {
        return this.getAndPushRange(1);
    }

    private TokenRange getAndPushRange(int end) {
        TokenRange oldRange = this.lastRange;
        this.lastRange = TokenRange.between(this.lastRange.end(), this.lastRange.end() + end);
        return TokenRange.between(oldRange.end(), oldRange.end() + end);
    }

    @Override
    public void accept(String search) {
        this.reset();
        StringSearcher.search(search, this, FormattingContext.empty());
    }

    @Nullable
    public FormattedCharSequence format(String currentString, int offset) {
        Pair<TokenRange, Style> token;
        TokenRange range;
        int subEnd;
        ArrayList<FormattedCharSequence> sequences = new ArrayList<FormattedCharSequence>();
        int index = 0;
        Iterator<Pair<TokenRange, Style>> iterator = this.tokens.iterator();
        while (iterator.hasNext() && (subEnd = Math.max((range = (TokenRange)(token = iterator.next()).getFirst()).start() - offset, 0)) < currentString.length()) {
            int subStart = Math.min(range.end() - offset, currentString.length());
            if (subStart <= 0) continue;
            sequences.add(FormattedCharSequence.forward((String)currentString.substring(index, subEnd), (Style)((Style)token.getSecond())));
            sequences.add(FormattedCharSequence.forward((String)currentString.substring(subEnd, subStart), (Style)((Style)token.getSecond())));
            index = subStart;
        }
        sequences.add(FormattedCharSequence.forward((String)currentString.substring(index), (Style)Style.EMPTY));
        return FormattedCharSequence.composite(sequences);
    }
}

