/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.autcomplete;

import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.TokenRange;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.blamejared.searchables.api.autcomplete.CompletionSuggestion;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import org.joml.Vector2d;

public class AutoComplete<T>
extends class_339
implements Consumer<String> {
    private final SearchableType<T> type;
    private final AutoCompletingEditBox<T> editBox;
    private final Supplier<List<T>> entries;
    private final int suggestionHeight;
    private final int maxSuggestions;
    private List<CompletionSuggestion> suggestions;
    private int displayOffset;
    private int selectedIndex;
    private final Vector2d lastMousePosition;
    private int lastCursorPosition;

    public AutoComplete(SearchableType<T> type, AutoCompletingEditBox<T> editBox, Supplier<List<T>> entries, int x, int y, int width, int suggestionHeight) {
        this(type, editBox, entries, x, y, width, suggestionHeight, 7);
    }

    public AutoComplete(SearchableType<T> type, AutoCompletingEditBox<T> editBox, Supplier<List<T>> entries, int x, int y, int width, int suggestionHeight, int maxSuggestions) {
        super(x, y, width, suggestionHeight * maxSuggestions, (class_2561)class_2561.method_43473());
        this.type = type;
        this.editBox = editBox;
        this.entries = entries;
        this.suggestionHeight = suggestionHeight;
        this.maxSuggestions = maxSuggestions;
        this.suggestions = List.of();
        this.displayOffset = 0;
        this.selectedIndex = -1;
        this.lastMousePosition = new Vector2d(0.0, 0.0);
        this.lastCursorPosition = -1;
    }

    @Override
    public void accept(String value) {
        int position = this.editBox().method_1881();
        if (this.lastCursorPosition != position) {
            this.displayOffset = 0;
            this.selectedIndex = 0;
            TokenRange replacementRange = this.editBox().completionVisitor().rangeAt(position);
            this.suggestions = this.type.getSuggestionsFor(this.entries.get(), value, position, replacementRange);
        }
        this.lastCursorPosition = position;
    }

    public boolean method_25405(double xpos, double ypos) {
        return super.method_25405(xpos, ypos) && ypos < (double)(this.method_46427() + this.suggestionHeight * this.shownSuggestions());
    }

    public boolean method_25401(double xpos, double ypos, double xDelta, double yDelta) {
        if (this.method_25405(xpos, ypos) || this.editBox().method_25405(xpos, ypos)) {
            this.displayOffset = (int)class_3532.method_15350((double)((double)this.displayOffset - yDelta), (double)0.0, (double)Math.max(this.suggestions.size() - this.maxSuggestions, 0));
            this.lastMousePosition.set(0.0);
            return true;
        }
        return false;
    }

    public boolean method_25402(double mx, double my, int mb) {
        if (super.method_25402(mx, my, mb)) {
            this.updateHoveringState(mx, my);
            if (this.selectedIndex != -1) {
                this.insertSuggestion();
            }
            return true;
        }
        return false;
    }

    public void insertSuggestion() {
        int index = this.displayOffset + this.selectedIndex;
        if (index >= 0 && index < this.suggestions.size()) {
            CompletionSuggestion suggestion = this.suggestions.get(index);
            this.editBox.deleteChars(suggestion.replacementRange());
            this.editBox.method_1867(suggestion.toInsert());
        }
    }

    public void method_48579(class_332 guiGraphics, int mx, int my, float partial) {
        if (!this.editBox.method_25370()) {
            return;
        }
        this.updateHoveringState(mx, my);
        for (int i = this.displayOffset; i < Math.min(this.displayOffset + this.maxSuggestions, this.suggestions.size()); ++i) {
            CompletionSuggestion suggestion = this.suggestions.get(i);
            int minX = this.method_46426() + 2;
            int minY = this.method_46427() + this.suggestionHeight * (i - this.displayOffset);
            int maxY = minY + this.suggestionHeight;
            boolean hovered = this.selectedIndex != -1 && this.displayOffset + this.selectedIndex == i;
            guiGraphics.method_25294(this.method_46426(), minY, this.method_46426() + this.method_25368(), maxY, hovered ? -535752431 : -536870912);
            guiGraphics.method_27535(class_310.method_1551().field_1772, suggestion.display(), minX, minY + 1, hovered ? Objects.requireNonNull(class_124.field_1054.method_532()) : -1);
        }
        this.lastMousePosition.set((double)mx, (double)my);
    }

    private void updateHoveringState(double xpos, double ypos) {
        if (!this.lastMousePosition.equals(xpos, ypos)) {
            this.selectedIndex = -1;
            if (this.method_25405(xpos, ypos)) {
                int minY = this.method_46427();
                for (int i = 0; i < this.shownSuggestions(); ++i) {
                    int maxY = minY + this.suggestionHeight;
                    if (xpos >= (double)this.method_46426() && xpos <= (double)(this.method_46426() + this.method_25368()) && ypos >= (double)minY && ypos < (double)maxY) {
                        this.selectedIndex = i;
                    }
                    minY = maxY;
                }
            }
        }
    }

    public void scrollUp() {
        this.scrollUp(1);
    }

    public void scrollUp(int amount) {
        this.offsetDisplay(this.selectedIndex - amount);
    }

    public void scrollDown() {
        this.scrollDown(1);
    }

    public void scrollDown(int amount) {
        this.offsetDisplay(this.selectedIndex + amount);
    }

    private void offsetDisplay(int offset) {
        int halfSuggestions;
        int currentItem = this.displayOffset + (offset = class_3532.method_15340((int)offset, (int)0, (int)(this.shownSuggestions() - 1)));
        if (currentItem < this.displayOffset + (halfSuggestions = Math.floorDiv(this.maxSuggestions, 2))) {
            this.displayOffset = Math.max(currentItem - halfSuggestions, 0);
        } else if (currentItem > this.displayOffset + halfSuggestions) {
            this.displayOffset = Math.min(currentItem - halfSuggestions, Math.max(this.suggestions.size() - this.maxSuggestions, 0));
        }
        this.selectedIndex = currentItem - this.displayOffset;
    }

    private int shownSuggestions() {
        return Math.min(this.maxSuggestions, this.suggestions.size());
    }

    public int maxSuggestions() {
        return this.maxSuggestions;
    }

    public AutoCompletingEditBox<T> editBox() {
        return this.editBox;
    }

    protected void method_47399(class_6382 output) {
    }
}

