/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.api.registries;

import com.blamejared.mas.api.recipes.machines.RecipeMachineBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class RecipeRegistry {
    private static HashMap<String, RecipeMachineBase> crusherRecipes = new HashMap();
    private static HashMap<String, RecipeMachineBase> furnaceRecipes = new HashMap();
    private static HashMap<String, RecipeMachineBase> sawmillRecipes = new HashMap();

    public static void registerCrusherRecipe(String seedID, RecipeMachineBase recipe) {
        if (!crusherRecipes.containsKey(seedID)) {
            crusherRecipes.put(seedID, recipe);
        }
    }

    public static void registerCrusherRecipe(RecipeMachineBase recipe) {
        String id = String.format("%s;%s:%s;%s", recipe.getInput().func_77977_a(), recipe.getInput().func_77952_i(), recipe.getOutput().func_77977_a(), recipe.getOutput().func_77952_i());
        if (!crusherRecipes.containsKey(id)) {
            crusherRecipes.put(id, recipe);
        }
    }

    public static RecipeMachineBase getCrusherRecipeByID(String seedID) {
        if (crusherRecipes.containsKey(seedID)) {
            return crusherRecipes.get(seedID);
        }
        return null;
    }

    public static HashMap<String, RecipeMachineBase> getAllCrusherRecipes() {
        return crusherRecipes;
    }

    public static boolean isCrusherInput(ItemStack stack) {
        for (Map.Entry<String, RecipeMachineBase> ent : RecipeRegistry.getAllCrusherRecipes().entrySet()) {
            if (!ent.getValue().getInput().func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public static void registerFurnaceRecipe(String seedID, RecipeMachineBase recipe) {
        if (!furnaceRecipes.containsKey(seedID)) {
            furnaceRecipes.put(seedID, recipe);
        }
    }

    public static void registerFurnaceRecipe(RecipeMachineBase recipe) {
        String id = String.format("%s;%s:%s;%s", recipe.getInput().func_77977_a(), recipe.getInput().func_77952_i(), recipe.getOutput().func_77977_a(), recipe.getOutput().func_77952_i());
        if (!furnaceRecipes.containsKey(id)) {
            furnaceRecipes.put(id, recipe);
        }
    }

    public static RecipeMachineBase getFurnaceRecipeByID(String seedID) {
        if (furnaceRecipes.containsKey(seedID)) {
            return furnaceRecipes.get(seedID);
        }
        return null;
    }

    public static HashMap<String, RecipeMachineBase> getAllFurnaceRecipes() {
        return furnaceRecipes;
    }

    public static boolean isFurnaceInput(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null) {
            for (Map.Entry<String, RecipeMachineBase> ent : RecipeRegistry.getAllFurnaceRecipes().entrySet()) {
                if (!RecipeRegistry.compareStacks(ent.getValue().getInput(), stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerSawmillRecipe(String seedID, RecipeMachineBase recipe) {
        if (!sawmillRecipes.containsKey(seedID)) {
            sawmillRecipes.put(seedID, recipe);
        }
    }

    public static void registerSawmillRecipe(RecipeMachineBase recipe) {
        String id = String.format("%s;%s:%s;%s", recipe.getInput().func_77977_a(), recipe.getInput().func_77952_i(), recipe.getOutput().func_77977_a(), recipe.getOutput().func_77952_i());
        if (!sawmillRecipes.containsKey(id)) {
            sawmillRecipes.put(id, recipe);
        }
    }

    public static RecipeMachineBase getSawmillRecipeByID(String seedID) {
        if (sawmillRecipes.containsKey(seedID)) {
            return sawmillRecipes.get(seedID);
        }
        return null;
    }

    public static HashMap<String, RecipeMachineBase> getAllSawmillRecipes() {
        return sawmillRecipes;
    }

    public static boolean isSawmillInput(ItemStack stack) {
        for (Map.Entry<String, RecipeMachineBase> ent : RecipeRegistry.getAllSawmillRecipes().entrySet()) {
            if (!ent.getValue().getInput().func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean compareStacks(ItemStack input, ItemStack output) {
        return output.func_77973_b() == input.func_77973_b() && (input.func_77960_j() == Short.MAX_VALUE || output.func_77960_j() == input.func_77960_j());
    }
}

