package com.blamejared.mas.util;

import com.blamejared.mas.api.registries.RecipeRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.*;

public class NBTHelper {
    
    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(keyName);
    }
    
    public static void removeTag(ItemStack itemStack, String keyName) {
        if(itemStack.func_77978_p() != null) {
            itemStack.func_77978_p().func_82580_o(keyName);
        }
    }
    
    /**
     * Initializes the NBT Tag Compound for the given ItemStack if it is null
     *
     * @param itemStack The ItemStack for which its NBT Tag Compound is being
     *                  checked for initialization
     */
    public static void initNBTTagCompound(ItemStack itemStack) {
        if(itemStack != null && itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }
    
    public static void setLong(ItemStack itemStack, String keyName, long keyValue) {
        initNBTTagCompound(itemStack);
        
        itemStack.func_77978_p().func_74772_a(keyName, keyValue);
    }
    
    // String
    public static String getString(ItemStack itemStack, String keyName) {
        initNBTTagCompound(itemStack);
        
        if(!itemStack.func_77978_p().func_74764_b(keyName)) {
            setString(itemStack, keyName, "");
        }
        
        return itemStack.func_77978_p().func_74779_i(keyName);
    }
    
    public static void setString(ItemStack itemStack, String keyName, String keyValue) {
        initNBTTagCompound(itemStack);
        
        itemStack.func_77978_p().func_74778_a(keyName, keyValue);
    }
    
    // boolean
    public static boolean getBoolean(ItemStack itemStack, String keyName) {
        initNBTTagCompound(itemStack);
        
        if(!itemStack.func_77978_p().func_74764_b(keyName)) {
            setBoolean(itemStack, keyName, false);
        }
        
        return itemStack.func_77978_p().func_74767_n(keyName);
    }
    
    public static void setBoolean(ItemStack itemStack, String keyName, boolean keyValue) {
        initNBTTagCompound(itemStack);
        
        itemStack.func_77978_p().func_74757_a(keyName, keyValue);
    }
    
    // byte
    public static byte getByte(ItemStack itemStack, String keyName) {
        initNBTTagCompound(itemStack);
        
        if(!itemStack.func_77978_p().func_74764_b(keyName)) {
            setByte(itemStack, keyName, (byte) 0);
        }
        
        return itemStack.func_77978_p().func_74771_c(keyName);
    }
    
    public static void setByte(ItemStack itemStack, String keyName, byte keyValue) {
        initNBTTagCompound(itemStack);
        
        itemStack.func_77978_p().func_74774_a(keyName, keyValue);
    }
    
    // short
    public static short getShort(ItemStack itemStack, String keyName) {
        initNBTTagCompound(itemStack);
        
        if(!itemStack.func_77978_p().func_74764_b(keyName)) {
            setShort(itemStack, keyName, (short) 0);
        }
        
        return itemStack.func_77978_p().func_74765_d(keyName);
    }
    
    public static void setShort(ItemStack itemStack, String keyName, short keyValue) {
        initNBTTagCompound(itemStack);
        
        itemStack.func_77978_p().func_74777_a(keyName, keyValue);
    }
    
    // int
    public static int getInt(ItemStack itemStack, String keyName) {
        initNBTTagCompound(itemStack);
        
        if(!itemStack.func_77978_p().func_74764_b(keyName)) {
            setInteger(itemStack, keyName, 0);
        }
        
        return itemStack.func_77978_p().func_74762_e(keyName);
    }
    
    public static void setInteger(ItemStack itemStack, String keyName, int keyValue) {
        initNBTTagCompound(itemStack);
        
        itemStack.func_77978_p().func_74768_a(keyName, keyValue);
    }
    
    // long
    public static long getLong(ItemStack itemStack, String keyName) {
        initNBTTagCompound(itemStack);
        
        if(!itemStack.func_77978_p().func_74764_b(keyName)) {
            setLong(itemStack, keyName, 0);
        }
        
        return itemStack.func_77978_p().func_74763_f(keyName);
    }
    
    // float
    public static float getFloat(ItemStack itemStack, String keyName) {
        initNBTTagCompound(itemStack);
        
        if(!itemStack.func_77978_p().func_74764_b(keyName)) {
            setFloat(itemStack, keyName, 0);
        }
        
        return itemStack.func_77978_p().func_74760_g(keyName);
    }
    
    public static void setFloat(ItemStack itemStack, String keyName, float keyValue) {
        initNBTTagCompound(itemStack);
        
        itemStack.func_77978_p().func_74776_a(keyName, keyValue);
    }
    
    // double
    public static double getDouble(ItemStack itemStack, String keyName) {
        initNBTTagCompound(itemStack);
        
        if(!itemStack.func_77978_p().func_74764_b(keyName)) {
            setDouble(itemStack, keyName, 0);
        }
        
        return itemStack.func_77978_p().func_74769_h(keyName);
    }
    
    public static void setDouble(ItemStack itemStack, String keyName, double keyValue) {
        initNBTTagCompound(itemStack);
        
        itemStack.func_77978_p().func_74780_a(keyName, keyValue);
    }
    
    public static NBTTagCompound getTag(ItemStack itemStack) {
        initNBTTagCompound(itemStack);
        return itemStack.func_77978_p();
    }
    
    public static NBTTagList getTagList(ItemStack itemStack, String keyName, int type) {
        initNBTTagCompound(itemStack);
        return itemStack.func_77978_p().func_150295_c(keyName, type);
    }
    
    public static void setTagList(ItemStack itemStack, String keyName, NBTTagList list) {
        initNBTTagCompound(itemStack);
        
        itemStack.func_77978_p().func_74782_a(keyName, list);
        
    }
    
    public static boolean isStackEqual(ItemStack stack1, ItemStack stack2) {
        if(stack1.func_77978_p() != null && stack2.func_77978_p() == null) {
            return false;
        }
        if(stack1.func_77978_p() == null && stack2.func_77978_p() != null) {
            return false;
        }
        if(stack1.func_77978_p() == null && stack2.func_77978_p() == null) {
            return stack1.func_77969_a(stack2);
        }
        
        return stack1.func_77969_a(stack2) && stack1.func_77978_p().equals(stack2.func_77978_p());
    }
    
    public static boolean isInputEqual(ItemStack input, ItemStack output) {
        if(input.func_77978_p() != null && output.func_77978_p() == null) {
            return false;
        }
        if(input.func_77978_p() == null && output.func_77978_p() != null) {
            return false;
        }
        if(input.func_77978_p() == null && output.func_77978_p() == null) {
            return RecipeRegistry.compareStacks(input, output);
        }
        if(input.func_77978_p().func_150296_c().equals(output.func_77978_p().func_150296_c())) {
            for(String s : input.func_77978_p().func_150296_c()) {
                if(!input.func_77978_p().func_74781_a(s).equals(output.func_77978_p().func_74781_a(s))) {
                    return false;
                }
            }
        }
        return RecipeRegistry.compareStacks(input, output);
    }
    
}
