package com.blamejared.mas.tileentities.machine;

import com.blamejared.mas.api.capabilities.ItemStackHandlerMachine;
import com.blamejared.mas.api.recipes.machines.RecipeMachineBase;
import com.blamejared.mas.blocks.machines.BlockMachine;
import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.machines.MessageMachineBase;
import com.blamejared.mas.util.NBTHelper;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.items.CapabilityItemHandler;

import javax.annotation.Nullable;
import java.util.HashMap;

/**
 * Created by Jared on 5/31/2016.
 */
public abstract class TileEntityMachineBase<E extends RecipeMachineBase> extends TileEntity implements ITickable {
    
    public ItemStackHandlerMachine itemStackHandler;
    public int itemCycleTime; // How long the current cycle has been running
    public int deviceCycleTime; // How long the machine will cycle
    public byte state;
    public int needCycleTime; // Based on everything how long should this
    public BaseTeslaContainer container;
    // take?????
    private int currentTime = 0;
    private int totalTime = 0;
    // empty if not currently working on any valid recipe
    private String recipeIndex = "";
    private long prevEnergy;
    
    public TileEntityMachineBase(int energyCap, int invSize) {
        container = new BaseTeslaContainer(10000, 250, 250);
        itemStackHandler = new ItemStackHandlerMachine(this, 2);
    }
    
    public int getTotalTime() {
        return totalTime;
    }
    
    public void setTotalTime(int totalTime) {
        this.totalTime = totalTime;
    }
    
    public String getRecipeIndex() {
        return recipeIndex;
    }
    
    public void setRecipeIndex(String recipeIndex) {
        this.recipeIndex = recipeIndex;
    }
    
    public int getCurrentTime() {
        return currentTime;
    }
    
    public abstract int getEnergyUsed();
    
    public abstract E getRecipe(String index);
    
    public abstract HashMap<String, E> getRecipes();
    
    public abstract boolean isValidInput(ItemStack stack);
    
    public void func_73660_a() {
        boolean canWork = false;
        boolean sendUpdate = false;
        // If we are still working then cycle the counter down 1
        if(this.deviceCycleTime > 0) {
            this.deviceCycleTime--;
            if(!field_145850_b.func_180495_p(func_174877_v()).func_177229_b(BlockMachine.isActive)) {
                ((BlockMachine) field_145850_b.func_180495_p(func_174877_v()).func_177230_c()).setState(true, this.field_145850_b, func_174877_v());
            }
        } else {
            if(field_145850_b.func_180495_p(func_174877_v()).func_177229_b(BlockMachine.isActive)) {
                ((BlockMachine) field_145850_b.func_180495_p(func_174877_v()).func_177230_c()).setState(false, this.field_145850_b, func_174877_v());
            }
        }
        if(!this.field_145850_b.field_72995_K) {
            if(prevEnergy != this.container.getStoredPower()) {
                prevEnergy = this.container.getStoredPower();
                sendUpdate = true;
            }
            E recipe = null;
            if(itemStackHandler.getStackInSlot(0) != null && !getRecipeIndex().isEmpty() && this.container.getStoredPower() > 0) {
                recipe = getRecipe(getRecipeIndex());
                if(recipe != null) {
                    if(this.container.getStoredPower() >= getEnergyUsed()) {
                        if(itemStackHandler.getStackInSlot(1) != null) {
                            if(NBTHelper.isInputEqual(recipe.getOutput(), itemStackHandler.getStackInSlot(1))) {
                                if(itemStackHandler.getStackInSlot(1).func_190916_E() + recipe.getOutputAmount() < itemStackHandler.getStackInSlot(1).func_77976_d()) {
                                    if(itemStackHandler.getStackInSlot(0).func_190916_E() >= recipe.getInputamount()) {
                                        canWork = true;
                                    }
                                }
                            }
                        } else {
                            if(itemStackHandler.getStackInSlot(0).func_190916_E() >= recipe.getInputamount()) {
                                canWork = true;
                            }
                        }
                        
                    }
                    
                    
                }
                
            }
            
            // Can we run a new item
            if(this.deviceCycleTime == 0 && canWork) {
                
                this.deviceCycleTime = 40;
                this.needCycleTime = 40;
                sendUpdate = true;
                
            }
            // Keep working if there is something in progress
            
            if(this.deviceCycleTime > 0 && canWork) {
                
                this.itemCycleTime++;
                if(this.itemCycleTime == 40) {
                    
                    this.itemCycleTime = 0;
                    process();
                    this.container.takePower(getEnergyUsed(), false);
                    sendUpdate = true;
                    
                }
                
            } else {
                
                this.itemCycleTime = 0;
                
            }
            
            // Last check
            if(this.deviceCycleTime > 0) {
                sendUpdate = true;
                
            }
        }
        
        
        if(sendUpdate) {
            this.func_70296_d();
            this.state = this.deviceCycleTime > 0 ? (byte) 1 : (byte) 0;
            func_145831_w().func_175641_c(func_174877_v(), this.func_145838_q(), 1, this.state);
            PacketHandler.INSTANCE.sendToAllAround(new MessageMachineBase(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double) this.func_174877_v().func_177958_n(), (double) this.func_174877_v().func_177956_o(), (double) this.func_174877_v().func_177952_p(), 128d));
            this.field_145850_b.func_175685_c(func_174877_v(), func_145838_q(), true);
            
        }
        
    }
    
    @Override
    public void func_70296_d() {
        super.func_70296_d();
        PacketHandler.INSTANCE.sendToAllAround(new MessageMachineBase(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double) this.func_174877_v().func_177958_n(), (double) this.func_174877_v().func_177956_o(), (double) this.func_174877_v().func_177952_p(), 128d));
        
    }
    
    
    /* NBT */
    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        itemStackHandler.deserializeNBT(tags.func_74775_l("items"));
        currentTime = tags.func_74762_e("currentTime");
        String index = tags.func_74779_i("recipeIndex");
        if(index.equals("___null")) {
            index = "";
        }
        setRecipeIndex(index);
        deviceCycleTime = tags.func_74762_e("deviceCycleTime");
        itemCycleTime = tags.func_74762_e("itemCycleTime");
        needCycleTime = tags.func_74762_e("needCycleTime");
        updateCurrentRecipe();
    }
    
    
    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        tags.func_74782_a("items", itemStackHandler.serializeNBT());
        tags.func_74768_a("currentTime", currentTime);
        String index = getRecipeIndex();
        if(index == null || index.isEmpty()) {
            index = "___null";
        }
        tags.func_74778_a("recipeIndex", index);
        
        tags.func_74768_a("deviceCycleTime", deviceCycleTime);
        tags.func_74768_a("itemCycleTime", itemCycleTime);
        tags.func_74768_a("needCycleTime", needCycleTime);
        return tags;
    }
    
    
    public boolean process() {
        if(!getRecipeIndex().isEmpty()) {
            E recipe = getRecipe(getRecipeIndex());
            if(recipe != null && itemStackHandler.getStackInSlot(0) != null && recipe.matchesExact(itemStackHandler.getStackInSlot(0))) {
                if(itemStackHandler.getStackInSlot(1) == null || NBTHelper.isInputEqual(itemStackHandler.getStackInSlot(1), recipe.getOutput())) {
                    itemStackHandler.extractItem(0, 1, false);
                    currentTime++;
                    if(currentTime >= recipe.getInputamount()) {
                        ItemStack out = recipe.getOutput().func_77946_l();
                        out.func_190920_e(recipe.getOutputAmount());
                        itemStackHandler.insertItem(1, out, false);
                        
                        currentTime = 0;
                    }
                }
                return true;
            }
        }
        currentTime = 0;
        return false;
    }
    
    
    public void updateCurrentRecipe() {
        setRecipeIndex("");
        ItemStack inputStack = itemStackHandler.getStackInSlot(0);
        if(inputStack != null && inputStack.func_190916_E() > 0) {
            for(String id : getRecipes().keySet()) {
                E recipe = getRecipe(id);
                if(recipe != null && recipe.matchesExact(inputStack)) {
                    setRecipeIndex(id);
                    break;
                }
            }
        }
    }
    
    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        func_145839_a(pkt.func_148857_g());
    }
    
    @Nullable
    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        func_189515_b(tag);
        return new SPacketUpdateTileEntity(func_174877_v(), 0, tag);
    }
    
    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        
        if(capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_HOLDER)
            return (T) this.container;
        else if(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T) this.itemStackHandler;
        }
        
        return super.getCapability(capability, facing);
    }
    
    
    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if(capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_HOLDER)
            return true;
        else if(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
    
}
