package com.blamejared.mas.proxies;

import com.blamejared.mas.blocks.MBlocks;
import com.blamejared.mas.client.gui.GuiHandler;
import com.blamejared.mas.items.MItems;
import com.blamejared.mas.reference.Reference;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;

import java.util.Map;

public class ClientProxy extends CommonProxy {
    
    @Override
    public void registerRenderersPre() {
        super.registerRenderersPre();
    }
    
    @Override
    public void registerRenderers() {
        super.registerRenderers();
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        for(Map.Entry<String, Item> ent : MItems.renderMap.entrySet()) {
            renderItem.func_175037_a().func_178086_a(ent.getValue(), 0, new ModelResourceLocation(Reference.MODID + ":" + ent.getKey(), "inventory"));
        }
        
        for(Map.Entry<String, Block> ent : MBlocks.renderMap.entrySet()) {
            renderItem.func_175037_a().func_178086_a(Item.func_150898_a(ent.getValue()), 0, new ModelResourceLocation(Reference.MODID + ":" + ent.getKey(), "inventory"));
        }
    }
    
    @Override
    public void registerEvents() {
        super.registerEvents();
    }
    
    @Override
    public void registerGuis() {
        super.registerGuis();
        new GuiHandler();
    }
    
    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
    
}
