package com.blamejared.mas.network.messages.tiles.generator;

import com.blamejared.mas.api.generators.GeneratorBase;
import io.netty.buffer.ByteBuf;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.*;

public class MessageGenerator implements IMessage, IMessageHandler<MessageGenerator, IMessage> {
    
    private int x;
    private int y;
    private int z;
    private int generationTimer;
    private int generationTimerDefault;
    private long energy;
    
    public MessageGenerator() {
        
    }
    
    public MessageGenerator(TileEntity tile) {
        this((GeneratorBase) tile);
    }
    
    public MessageGenerator(GeneratorBase tile) {
        this.x = tile.func_174877_v().func_177958_n();
        this.y = tile.func_174877_v().func_177956_o();
        this.z = tile.func_174877_v().func_177952_p();
        this.generationTimer = tile.generationTimer;
        this.generationTimerDefault = tile.generationTimerDefault;
        this.energy = tile.container.getStoredPower();
    }
    
    @Override
    public void fromBytes(ByteBuf buf) {
        
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        
        this.generationTimer = buf.readInt();
        this.generationTimerDefault = buf.readInt();
        this.energy = buf.readLong();
    }
    
    @Override
    public void toBytes(ByteBuf buf) {
        
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        
        buf.writeInt(generationTimer);
        buf.writeInt(generationTimerDefault);
        buf.writeLong(energy);
    }
    
    @Override
    public IMessage onMessage(MessageGenerator message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> handle(message, ctx));
        return null;
        
    }
    
    private void handle(MessageGenerator message, MessageContext ctx) {
        if(FMLClientHandler.instance().getClient().field_71441_e != null) {
            TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(new BlockPos(message.x, message.y, message.z));
            if(tileEntity instanceof GeneratorBase) {
                ((GeneratorBase) tileEntity).generationTimer = message.generationTimer;
                ((GeneratorBase) tileEntity).generationTimerDefault = message.generationTimerDefault;
                long cap = ((GeneratorBase) tileEntity).container.getCapacity();
                long input = ((GeneratorBase) tileEntity).container.getInputRate();
                long output = ((GeneratorBase) tileEntity).container.getOutputRate();
                ((GeneratorBase) tileEntity).container = new BaseTeslaContainer(message.energy, cap, input, output);
                
            }
        }
    }
    
}
