package com.blamejared.mas.client.gui.base;

import com.blamejared.mas.MAS;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum GuiCarrier {
    ENTITY {
        @Override
        public IHasGui getHasGUI(EntityPlayer player, World world, BlockPos blockPos) {
            IHasGui hasGui = null;
            Entity entity = world.func_73045_a(blockPos.func_177958_n());
            if(entity instanceof IHasGui) {
                hasGui = (IHasGui) entity;
            }
            return hasGui;
        }
        
        public void openGui(Entity entity, EntityPlayer player, World world) {
            player.openGui(MAS.INSTANCE, ENTITY.ordinal(), world, entity.func_145782_y(), 0, 0);
        }
    }, BLOCK {
        @Override
        public IHasGui getHasGUI(EntityPlayer player, World world, BlockPos blockPos) {
            IHasGui hasGui = null;
            
            Block block = world.func_180495_p(blockPos).func_177230_c();
            if(block instanceof IHasGui) {
                hasGui = (IHasGui) block;
            } else {
                TileEntity tileEntity = world.func_175625_s(blockPos);
                if(tileEntity instanceof IHasGui) {
                    hasGui = (IHasGui) tileEntity;
                }
            }
            
            return hasGui;
        }
        
        public void openGui(EntityPlayer player, World world, BlockPos blockPos) {
            player.openGui(MAS.INSTANCE, BLOCK.ordinal(), world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
    }, ITEMSTACK {
        @Override
        public IHasGui getHasGUI(EntityPlayer player, World world, BlockPos blockPos) {
            IHasGui hasGui = null;
            ItemStack itemStack = player.func_184607_cu();
            if(itemStack != null && IHasGui.class != null && IHasGui.class.isInstance(itemStack.func_77973_b())) {
                hasGui = (IHasGui) itemStack.func_77973_b();
            }
            return hasGui;
        }
        
        public void openGui(EntityPlayer player, World world, BlockPos blockPos) {
            player.openGui(MAS.INSTANCE, ITEMSTACK.ordinal(), world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
    };
    
    public abstract IHasGui getHasGUI(EntityPlayer player, World world, BlockPos blockPos);
}
