package com.blamejared.mas.client.gui.base;

import com.blamejared.mas.api.generators.GeneratorBase;
import com.blamejared.mas.tileentities.machine.TileEntityMachineBase;
import com.blamejared.mas.util.RenderUtils;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.inventory.*;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

import java.util.function.Predicate;

public class GuiBase extends GuiContainer {
    
    Container container;
    TileEntity tile;
    //Not used yet
    //ResourceLocation overlays;
    EntityPlayer player;
    String name;
    
    //Should show title of machine
    private boolean title;
    //Should outline items
    private Predicate<ItemStack> shouldOutline = itemStack -> false;
    
    public GuiBase(Container container, TileEntity tile, EntityPlayer player, String name) {
        super(container);
        this.container = container;
        this.tile = tile;
        this.name = I18n.func_74838_a(name);
        this.player = player;
    }
    
    @Override
    public void func_73866_w_() {
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        super.func_73866_w_();
    }
    
    @Override
    protected void func_146979_b(int mx, int my) {
        if(title)
            this.field_146289_q.func_78276_b(this.name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.name) / 2, 6, 0xa0a0a0);
        
        GlStateManager.func_179123_a();
        GlStateManager.func_179131_c(1, 1, 1, 1);
        
        Minecraft.func_71410_x().field_71446_o.func_110577_a(getTexture());
        GlStateManager.func_179099_b();
    
        if(Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && getShouldOutline() != null)
            drawOutlines();
    }
    
    protected void drawOutlines() {
        GL11.glPushMatrix();
        GlStateManager.func_179123_a();
        GL11.glDepthMask(false);
        GL11.glDisable(GL11.GL_LIGHTING);
        GL11.glDisable(GL11.GL_FOG);
        GL11.glDisable(GL11.GL_ALPHA_TEST);
        GL11.glEnable(GL11.GL_BLEND);
        for(int x = 0; x < 9; x++) {
            ItemStack stack = player.field_71071_by.func_70301_a(x);
            if(stack != ItemStack.field_190927_a) {
                if(getShouldOutline().test(stack)) {
                    RenderUtils.drawRectNoFade(8 + 18 * x, 142, 280, 16, 16, 0f, 0.8f, 0, 2f, 1);
                } else
                    RenderUtils.drawRectNoFade(8 + 18 * x, 142, 280, 16, 16, 0.8f, 0, 0, 2f, 1);
            }
        }
        for(int y = 0; y < 3; y++) {
            for(int x = 0; x < 9; x++) {
                ItemStack stack = player.field_71071_by.func_70301_a(x + y * 9 + 9);
                if(stack != ItemStack.field_190927_a) {
                    if(getShouldOutline().test(stack)) {
                        RenderUtils.drawRectNoFade(8 + 18 * x, 84 + (y * 18), 280, 16, 16, 0f, 0.8f, 0f, 2f, 1);
                    } else
                        RenderUtils.drawRectNoFade(8 + 18 * x, 84 + (y * 18), 280, 16, 16, 0.8f, 0, 0, 2f, 1);
                }
            }
        }
        GL11.glEnable(GL11.GL_LIGHTING);
        GL11.glEnable(GL11.GL_FOG);
        GL11.glEnable(GL11.GL_ALPHA_TEST);
        GL11.glEnable(GL11.GL_BLEND);
        GL11.glDepthMask(true);
        GlStateManager.func_179099_b();
        GL11.glPopMatrix();
    }
    
    //Override this
    public ResourceLocation getTexture() {
        return null;
    }
    
    //Progress of machine recipe
    public void drawMachineProgress(TileEntityMachineBase tile) {
        drawMachineProgress(tile.itemCycleTime, tile.needCycleTime);
    }
    
    //Progress of machine recipe
    public void drawMachineProgress(int itemCycleTime, int needCycleTime) {
        int progressWidth = (int) (((float) itemCycleTime / needCycleTime) * 33);
        func_73729_b(72, 36, 6, 168, progressWidth, 13);
    }
    
    //How full is power bar
    public void drawPowerBar(BaseTeslaContainer container) {
        GlStateManager.func_179123_a();
        int barWidth = (int) (((float) container.getStoredPower() / container.getCapacity()) * 88);
        func_73729_b(44, 60, 44, 166, barWidth, 19);
        GlStateManager.func_179099_b();
    }
    
    //Generator progress
    public void drawGeneratorProgress(int x, int y, GeneratorBase tile) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        int barHeight = (int) (((float) tile.generationTimer / tile.generationTimerDefault) * 16);
        func_73729_b(x, y + barHeight, 176, barHeight, 16, barHeight + 16);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }
    
    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179123_a();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(getTexture());
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
        GlStateManager.func_179099_b();
    }
    
    
    public void setOutlinePredicate(Predicate<ItemStack> predicate) {
        this.shouldOutline = predicate;
    }
    
    public Predicate<ItemStack> getShouldOutline() {
        return shouldOutline;
    }
    
    public boolean isTitle() {
        return title;
    }
    
    public void setTitle(boolean title) {
        this.title = title;
    }
}
