package com.blamejared.mas.blocks.machines;

import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.machines.MessageMachineBase;
import com.blamejared.mas.tileentities.machine.TileEntityMachineBase;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.*;
import net.minecraft.block.state.*;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.*;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.*;

/**
 * Created by Jared on 5/3/2016.
 */
public abstract class BlockMachine extends BlockContainer {
    
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a("facing", EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool isActive = PropertyBool.func_177716_a("active");
    
    protected BlockMachine() {
        super(Material.field_151573_f);
    }
    
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
    
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, new IProperty[]{FACING, isActive});
    }
    
    /**
     * Called by ItemBlocks just before a block is actually set in the world, to
     * allow for adjustments to the IBlockstate
     */
    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, placer.func_174811_aO().func_176734_d()).func_177226_a(isActive, false);
    }
    
    /**
     * Possibly modify the given BlockState before rendering it on an Entity
     * (Minecarts, Endermen, ...)
     */
    @SideOnly(Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a(FACING, EnumFacing.SOUTH).func_177226_a(isActive, false);
    }
    
    /**
     * Convert the given metadata into a BlockState for this Block
     */
    public IBlockState func_176203_a(int meta) {
        boolean active = false;
        if((meta & 15 >> 2) == 1) {
            active = true;
        }
        return this.func_176223_P().func_177226_a(FACING, EnumFacing.func_176731_b(meta)).func_177226_a(isActive, active);
    }
    
    /**
     * Convert the BlockState into the correct metadata value
     */
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i = i | (state.func_177229_b(FACING)).func_176736_b();
        if(state.func_177229_b(isActive)) {
            i = i | 1 << 2;
        } else {
            i = i | 0 << 2;
        }
        return i;
    }
    
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        
        if(tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a(worldIn, pos, (IInventory) tileentity);
            worldIn.func_175666_e(pos, this);
        }
        
        super.func_180663_b(worldIn, pos, state);
    }
    
    public void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        worldIn.func_180501_a(pos, func_176223_P().func_177226_a(FACING, iblockstate.func_177229_b(FACING)).func_177226_a(isActive, active), 3);
        worldIn.func_180501_a(pos, func_176223_P().func_177226_a(FACING, iblockstate.func_177229_b(FACING)).func_177226_a(isActive, active), 3);
        
        if(tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
            PacketHandler.INSTANCE.sendToAllAround(new MessageMachineBase((TileEntityMachineBase) tileentity), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), (double) tileentity.func_174877_v().func_177958_n(), (double) tileentity.func_174877_v().func_177956_o(), (double) tileentity.func_174877_v().func_177952_p(), 128d));
        }
    }
}
