package com.blamejared.mas.blocks.generators.base;

import com.blamejared.mas.MAS;
import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.generator.MessageGenerator;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.*;
import net.minecraft.block.state.*;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

import java.lang.reflect.InvocationTargetException;

public abstract class BlockBaseGenerator extends BlockContainer {
    
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a("facing", EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool isActive = PropertyBool.func_177716_a("active");
    
    private final Class<? extends TileEntity> tileClass;
    
    public BlockBaseGenerator(Class<? extends TileEntity> tileClass) {
        super(Material.field_151573_f);
        this.tileClass = tileClass;
    }
    
    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        worldIn.func_180501_a(pos, iblockstate.func_177230_c().func_176223_P().func_177226_a(FACING, iblockstate.func_177229_b(FACING)).func_177226_a(isActive, active), 3);
        
        if(tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
            PacketHandler.INSTANCE.sendToAllAround(new MessageGenerator(tileentity), new NetworkRegistry.TargetPoint(worldIn.field_73011_w.getDimension(), tileentity.func_174877_v().func_177958_n(), tileentity.func_174877_v().func_177956_o(), tileentity.func_174877_v().func_177952_p(), 128d));
        }
    }
    
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, new IProperty[]{FACING, isActive});
    }
    
    /**
     * Convert the given metadata into a BlockState for this Block
     */
    public IBlockState func_176203_a(int meta) {
        boolean active = false;
        if((meta & 15 >> 2) == 1) {
            active = true;
        }
        return this.func_176223_P().func_177226_a(FACING, EnumFacing.func_176731_b(meta)).func_177226_a(isActive, active);
    }
    
    /**
     * Convert the BlockState into the correct metadata value
     */
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i = i | (state.func_177229_b(FACING)).func_176736_b();
        if(state.func_177229_b(isActive)) {
            i = i | 1 << 2;
        } else {
            i = i | 0 << 2;
        }
        return i;
    }
    
    
    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(FACING, placer.func_174811_aO().func_176734_d()).func_177226_a(isActive, false);
    }
    
    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if(!worldIn.field_72995_K) {
            playerIn.openGui(MAS.INSTANCE, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }
    
    
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
    
    @Override
    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        try {
            return tileClass.getConstructor().newInstance();
        } catch(InstantiationException | IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }
    
}
