package com.blamejared.mas.api.recipes.machines;

import com.blamejared.mas.util.NBTHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

import java.util.List;

/**
 * Created by Jared on 5/31/2016.
 */
public class RecipeMachineBase {
    
    private ItemStack input;
    private ItemStack output;
    private int inputAmount;
    private int outputAmount;
    
    public RecipeMachineBase(ItemStack input, ItemStack output, int inputAmount, int outputAmount) {
        this.input = input;
        this.input.func_77964_b(input.func_77952_i());
        this.output = output;
        this.output.func_77964_b(output.func_77952_i());
        this.inputAmount = inputAmount;
        this.outputAmount = outputAmount;
    }
    
    public int getOutputAmount() {
        return outputAmount;
    }
    
    public boolean matches(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs(stack);
        for(int id : ids) {
            String name = OreDictionary.getOreName(id);
            if(matches(name)) {
                return true;
            }
        }
        return stack != null && OreDictionary.itemMatches(stack, input, false);
    }
    
    private boolean matches(String oreDict) {
        List<ItemStack> stacks = OreDictionary.getOres(oreDict);
        for(ItemStack stack : stacks) {
            if(OreDictionary.itemMatches(stack, input, false)) {
                return true;
            }
        }
        return false;
    }
    
    public boolean matchesExact(ItemStack stack) {
        return NBTHelper.isInputEqual(input, stack);
    }
    
    public ItemStack getInput() {
        return input.func_77946_l();
    }
    
    public ItemStack getOutput() {
        return output.func_77946_l();
    }
    
    public int getInputamount() {
        return inputAmount;
    }
    
    @Override
    public String toString() {
        return "RecipeMachineBase{" + "input=" + input + ", output=" + output + ", inputAmount=" + inputAmount + ", outputAmount=" + outputAmount + '}';
    }
}
