package com.blamejared.mas.api.generators;

import com.blamejared.mas.blocks.generators.base.BlockBaseGenerator;
import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.generator.MessageGenerator;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.*;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.items.*;

import javax.annotation.Nullable;

public abstract class GeneratorBase extends TileEntity implements ITickable {
    
    public ItemStackHandler itemStackHandler;
    public int generationTimer = -1;
    public int generationTimerDefault = -1;
    
    public BaseTeslaContainer container;
    
    
    public GeneratorBase(int cap, int inventorySize) {
        container = new BaseTeslaContainer(cap, 50, 50);
        itemStackHandler = new ItemStackHandler(inventorySize);
    }
    
    public boolean isGenerating() {
        return generationTimer > -1;
    }
    
    
    protected boolean pushEnergy() {
        boolean pushed = false;
        for(EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity tile = field_145850_b.func_175625_s(func_174877_v().func_177972_a(dir));
            if(tile != null)
                if(tile.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir.func_176734_d()) || tile.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, dir.func_176734_d())) {
                    BaseTeslaContainer cont = (BaseTeslaContainer) tile.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, dir.func_176734_d());
                    container.takePower(cont.givePower(container.takePower(container.getOutputRate(), true), false), false);
                    if(!field_145850_b.field_72995_K) {
                        tile.func_70296_d();
                        func_70296_d();
                        pushed = true;
                    }
                }
        }
        return pushed;
    }
    
    @Override
    public void func_73660_a() {
        boolean sendUpdate = false;
        //            PacketHandler.INSTANCE.sendToAllAround(new MessageGenerator(this), new NetworkRegistry.TargetPoint(this.world.provider.getDimension(), (double) this.getPos().getX(), (double) this.getPos().getY(), (double) this.getPos().getZ(), 128d));
        
        if(generationTimerDefault < 0 && this.container.getStoredPower() < this.container.getCapacity()) {
            if(itemStackHandler.getStackInSlot(0) != null) {
                if(canGenerateEnergy(itemStackHandler.getStackInSlot(0))) {
                    generationTimer = getGenerationTime(itemStackHandler.getStackInSlot(0));
                    generationTimerDefault = getGenerationTime(itemStackHandler.getStackInSlot(0));
                    itemStackHandler.extractItem(0, 1, false);
                    if(!field_145850_b.field_72995_K)
                        sendUpdate = true;
                    
                }
            }
        }
        if(generationTimer < 0) {
            generationTimerDefault = -1;
            generationTimer = -1;
            if(!field_145850_b.field_72995_K)
                sendUpdate = true;
        }
        if(pushEnergy()) {
            sendUpdate = true;
        }
        if(generationTimerDefault > 0 && this.container.getStoredPower() < this.container.getCapacity()) {
            generationTimer--;
            this.container.givePower(getEnergyGenerated(), false);
            if(!field_145850_b.field_72995_K)
                sendUpdate = true;
        }
        
        if(!field_145850_b.field_72995_K) {
            if(sendUpdate) {
                this.func_70296_d();
                PacketHandler.INSTANCE.sendToAllAround(new MessageGenerator(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double) this.func_174877_v().func_177958_n(), (double) this.func_174877_v().func_177956_o(), (double) this.func_174877_v().func_177952_p(), 128d));
                this.field_145850_b.func_175685_c(func_174877_v(), func_145838_q(), true);
            }
        }
        boolean active = true;
        if(!isGenerating()) {
            active = false;
        }
        if(itemStackHandler.getStackInSlot(0) == null && !isGenerating()) {
            active = false;
        }
        if(this.container.getStoredPower() == this.container.getCapacity()) {
            active = false;
        }
        
        if(field_145850_b.func_180495_p(func_174877_v()).func_177229_b(BlockBaseGenerator.isActive) != active) {
            BlockBaseGenerator.setState(active, this.field_145850_b, this.field_174879_c);
        }
    }
    
    @Override
    public void func_70296_d() {
        super.func_70296_d();
        PacketHandler.INSTANCE.sendToAllAround(new MessageGenerator(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double) this.func_174877_v().func_177958_n(), (double) this.func_174877_v().func_177956_o(), (double) this.func_174877_v().func_177952_p(), 128d));
    }
    
    public abstract boolean canGenerateEnergy(ItemStack stack);
    
    public abstract int getGenerationTime(ItemStack stack);
    
    public abstract int getEnergyGenerated();
    
    
    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("items", itemStackHandler.serializeNBT());
        nbt.func_74768_a("generationTimer", generationTimer);
        nbt.func_74768_a("generationTimerDefault", generationTimerDefault);
        nbt.func_74782_a("TeslaContainer", this.container.serializeNBT());
        return nbt;
    }
    
    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.itemStackHandler.deserializeNBT(nbt.func_74775_l("items"));
        generationTimer = nbt.func_74762_e("generationTimer");
        generationTimerDefault = nbt.func_74762_e("generationTimerDefault");
        this.container = new BaseTeslaContainer(nbt.func_74775_l("TeslaContainer"));
    }
    
    @Nullable
    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        func_189515_b(tag);
        return new SPacketUpdateTileEntity(func_174877_v(), 0, tag);
    }
    
    @Override
    public NBTTagCompound func_189517_E_() {
        return func_189515_b(new NBTTagCompound());
    }
    
    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        func_145839_a(pkt.func_148857_g());
    }
    
    
    @Override
    @SuppressWarnings("unchecked")
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        
        if(capability == TeslaCapabilities.CAPABILITY_PRODUCER)
            return (T) this.container;
        else if(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T) this.itemStackHandler;
        }
        
        return super.getCapability(capability, facing);
    }
    
    
    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if(capability == TeslaCapabilities.CAPABILITY_PRODUCER)
            return true;
        else if(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
    
}
