package com.blamejared.mas.api.capabilities;

import com.blamejared.mas.tileentities.machine.TileEntityMachineBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.*;
import net.minecraftforge.common.util.*;
import net.minecraftforge.items.*;

/**
 * Created by Jared on 7/16/2016.
 */
public class ItemStackHandlerMachine implements IItemHandler, IItemHandlerModifiable, INBTSerializable<NBTTagCompound> {
    
    public TileEntityMachineBase tile;
    protected ItemStack[] stacks;
    
    public ItemStackHandlerMachine(TileEntityMachineBase tile, int size) {
        this.tile = tile;
        stacks = new ItemStack[size];
    }
    
    public ItemStackHandlerMachine(TileEntityMachineBase tile, ItemStack[] stacks) {
        this.tile = tile;
        this.stacks = stacks;
    }
    
    public void setSize(int size) {
        stacks = new ItemStack[size];
    }
    
    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        validateSlotIndex(slot);
        stacks[slot] = stack;
        if(stack != null && stack.func_190916_E() > 64) {
            stack.func_190920_e(64);
        }
        onContentsChanged(slot);
    }
    
    @Override
    public int getSlots() {
        return stacks.length;
    }
    
    @Override
    public ItemStack getStackInSlot(int slot) {
        validateSlotIndex(slot);
        return this.stacks[slot];
    }
    
    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if(stack == null || stack.func_190916_E() == 0)
            return null;
        
        validateSlotIndex(slot);
        
        ItemStack existing = this.stacks[slot];
        
        int limit = getStackLimit(slot, stack);
        
        if(existing != null) {
            if(!ItemHandlerHelper.canItemStacksStack(stack, existing))
                return stack;
            
            limit -= existing.func_190916_E();
        }
        
        if(slot == 0 && !tile.isValidInput(stack)) {
            return stack;
        }
        if(limit <= 0)
            return stack;
        
        boolean reachedLimit = stack.func_190916_E() > limit;
        
        if(!simulate) {
            if(existing == null) {
                this.stacks[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack;
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            onContentsChanged(slot);
        }
        
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.func_190916_E() - limit) : null;
    }
    
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if(amount == 0)
            return null;
        
        validateSlotIndex(slot);
        
        ItemStack existing = this.stacks[slot];
        
        if(existing == null)
            return null;
        
        int toExtract = Math.min(amount, existing.func_77976_d());
        
        if(existing.func_190916_E() <= toExtract) {
            if(!simulate) {
                this.stacks[slot] = null;
                onContentsChanged(slot);
            }
            return existing;
        } else {
            if(!simulate) {
                this.stacks[slot] = ItemHandlerHelper.copyStackWithSize(existing, existing.func_190916_E() - toExtract);
                onContentsChanged(slot);
            }
            
            return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
        }
    }
    
    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }
    
    protected int getStackLimit(int slot, ItemStack stack) {
        return stack.func_77976_d();
    }
    
    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for(int i = 0; i < stacks.length; i++) {
            if(stacks[i] != null) {
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74768_a("Slot", i);
                stacks[i].func_77955_b(itemTag);
                nbtTagList.func_74742_a(itemTag);
            }
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", nbtTagList);
        nbt.func_74768_a("Size", stacks.length);
        return nbt;
    }
    
    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        setSize(nbt.func_150297_b("Size", Constants.NBT.TAG_INT) ? nbt.func_74762_e("Size") : stacks.length);
        NBTTagList tagList = nbt.func_150295_c("Items", Constants.NBT.TAG_COMPOUND);
        for(int i = 0; i < tagList.func_74745_c(); i++) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            
            if(slot >= 0 && slot < stacks.length) {
                stacks[slot] = new ItemStack(itemTags);
            }
        }
        onLoad();
    }
    
    protected void validateSlotIndex(int slot) {
        if(slot < 0 || slot >= stacks.length)
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + stacks.length + ")");
    }
    
    protected void onLoad() {
        
    }
    
    protected void onContentsChanged(int slot) {
        if(slot == 0) {
            tile.updateCurrentRecipe();
        }
        if(!tile.func_145831_w().field_72995_K)
            tile.func_70296_d();
    }
}
