/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.util;

import com.blamejared.mas.api.registries.RecipeRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.getTagCompound() != null && itemStack.getTagCompound().hasKey(keyName);
    }

    public static void removeTag(ItemStack itemStack, String keyName) {
        if (itemStack.getTagCompound() != null) {
            itemStack.getTagCompound().removeTag(keyName);
        }
    }

    public static void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack != null && itemStack.getTagCompound() == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
    }

    public static void setLong(ItemStack itemStack, String keyName, long keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.getTagCompound().setLong(keyName, keyValue);
    }

    public static String getString(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.getTagCompound().hasKey(keyName)) {
            NBTHelper.setString(itemStack, keyName, "");
        }
        return itemStack.getTagCompound().getString(keyName);
    }

    public static void setString(ItemStack itemStack, String keyName, String keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.getTagCompound().setString(keyName, keyValue);
    }

    public static boolean getBoolean(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.getTagCompound().hasKey(keyName)) {
            NBTHelper.setBoolean(itemStack, keyName, false);
        }
        return itemStack.getTagCompound().getBoolean(keyName);
    }

    public static void setBoolean(ItemStack itemStack, String keyName, boolean keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.getTagCompound().setBoolean(keyName, keyValue);
    }

    public static byte getByte(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.getTagCompound().hasKey(keyName)) {
            NBTHelper.setByte(itemStack, keyName, (byte)0);
        }
        return itemStack.getTagCompound().getByte(keyName);
    }

    public static void setByte(ItemStack itemStack, String keyName, byte keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.getTagCompound().setByte(keyName, keyValue);
    }

    public static short getShort(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.getTagCompound().hasKey(keyName)) {
            NBTHelper.setShort(itemStack, keyName, (short)0);
        }
        return itemStack.getTagCompound().getShort(keyName);
    }

    public static void setShort(ItemStack itemStack, String keyName, short keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.getTagCompound().setShort(keyName, keyValue);
    }

    public static int getInt(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.getTagCompound().hasKey(keyName)) {
            NBTHelper.setInteger(itemStack, keyName, 0);
        }
        return itemStack.getTagCompound().getInteger(keyName);
    }

    public static void setInteger(ItemStack itemStack, String keyName, int keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.getTagCompound().setInteger(keyName, keyValue);
    }

    public static long getLong(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.getTagCompound().hasKey(keyName)) {
            NBTHelper.setLong(itemStack, keyName, 0L);
        }
        return itemStack.getTagCompound().getLong(keyName);
    }

    public static float getFloat(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.getTagCompound().hasKey(keyName)) {
            NBTHelper.setFloat(itemStack, keyName, 0.0f);
        }
        return itemStack.getTagCompound().getFloat(keyName);
    }

    public static void setFloat(ItemStack itemStack, String keyName, float keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.getTagCompound().setFloat(keyName, keyValue);
    }

    public static double getDouble(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.getTagCompound().hasKey(keyName)) {
            NBTHelper.setDouble(itemStack, keyName, 0.0);
        }
        return itemStack.getTagCompound().getDouble(keyName);
    }

    public static void setDouble(ItemStack itemStack, String keyName, double keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.getTagCompound().setDouble(keyName, keyValue);
    }

    public static NBTTagCompound getTag(ItemStack itemStack) {
        NBTHelper.initNBTTagCompound(itemStack);
        return itemStack.getTagCompound();
    }

    public static NBTTagList getTagList(ItemStack itemStack, String keyName, int type) {
        NBTHelper.initNBTTagCompound(itemStack);
        return itemStack.getTagCompound().getTagList(keyName, type);
    }

    public static void setTagList(ItemStack itemStack, String keyName, NBTTagList list) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.getTagCompound().setTag(keyName, (NBTBase)list);
    }

    public static boolean isStackEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.getTagCompound() != null && stack2.getTagCompound() == null) {
            return false;
        }
        if (stack1.getTagCompound() == null && stack2.getTagCompound() != null) {
            return false;
        }
        if (stack1.getTagCompound() == null && stack2.getTagCompound() == null) {
            return stack1.isItemEqual(stack2);
        }
        return stack1.isItemEqual(stack2) && stack1.getTagCompound().equals((Object)stack2.getTagCompound());
    }

    public static boolean isInputEqual(ItemStack input, ItemStack output) {
        if (input.getTagCompound() != null && output.getTagCompound() == null) {
            return false;
        }
        if (input.getTagCompound() == null && output.getTagCompound() != null) {
            return false;
        }
        if (input.getTagCompound() == null && output.getTagCompound() == null) {
            return RecipeRegistry.compareStacks(input, output);
        }
        if (input.getTagCompound().getKeySet().equals(output.getTagCompound().getKeySet())) {
            for (String s : input.getTagCompound().getKeySet()) {
                if (input.getTagCompound().getTag(s).equals((Object)output.getTagCompound().getTag(s))) continue;
                return false;
            }
        }
        return RecipeRegistry.compareStacks(input, output);
    }
}

