/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.tileentities.machine;

import com.blamejared.mas.api.capabilities.ItemStackHandlerMachine;
import com.blamejared.mas.api.recipes.machines.RecipeMachineBase;
import com.blamejared.mas.blocks.machines.BlockMachine;
import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.machines.MessageMachineBase;
import com.blamejared.mas.util.NBTHelper;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityMachineBase<E extends RecipeMachineBase>
extends TileEntity
implements ITickable {
    public ItemStackHandlerMachine itemStackHandler;
    public int itemCycleTime;
    public int deviceCycleTime;
    public byte state;
    public int needCycleTime;
    public BaseTeslaContainer container = new BaseTeslaContainer(10000L, 250L, 250L);
    private int currentTime = 0;
    private int totalTime = 0;
    private String recipeIndex = "";
    private long prevEnergy;

    public TileEntityMachineBase(int energyCap, int invSize) {
        this.itemStackHandler = new ItemStackHandlerMachine(this, 2);
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(int totalTime) {
        this.totalTime = totalTime;
    }

    public String getRecipeIndex() {
        return this.recipeIndex;
    }

    public void setRecipeIndex(String recipeIndex) {
        this.recipeIndex = recipeIndex;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public abstract int getEnergyUsed();

    public abstract E getRecipe(String var1);

    public abstract HashMap<String, E> getRecipes();

    public abstract boolean isValidInput(ItemStack var1);

    public void update() {
        boolean canWork = false;
        boolean sendUpdate = false;
        if (this.deviceCycleTime > 0) {
            --this.deviceCycleTime;
            if (!((Boolean)this.world.getBlockState(this.getPos()).getValue((IProperty)BlockMachine.isActive)).booleanValue()) {
                ((BlockMachine)this.world.getBlockState(this.getPos()).getBlock()).setState(true, this.world, this.getPos());
            }
        } else if (((Boolean)this.world.getBlockState(this.getPos()).getValue((IProperty)BlockMachine.isActive)).booleanValue()) {
            ((BlockMachine)this.world.getBlockState(this.getPos()).getBlock()).setState(false, this.world, this.getPos());
        }
        if (!this.world.isRemote) {
            if (this.prevEnergy != this.container.getStoredPower()) {
                this.prevEnergy = this.container.getStoredPower();
                sendUpdate = true;
            }
            RecipeMachineBase recipe = null;
            if (this.itemStackHandler.getStackInSlot(0) != null && !this.getRecipeIndex().isEmpty() && this.container.getStoredPower() > 0L && (recipe = (RecipeMachineBase)this.getRecipe(this.getRecipeIndex())) != null && this.container.getStoredPower() >= (long)this.getEnergyUsed()) {
                if (this.itemStackHandler.getStackInSlot(1) != null) {
                    if (NBTHelper.isInputEqual(recipe.getOutput(), this.itemStackHandler.getStackInSlot(1)) && this.itemStackHandler.getStackInSlot(1).getCount() + recipe.getOutputAmount() < this.itemStackHandler.getStackInSlot(1).getMaxStackSize() && this.itemStackHandler.getStackInSlot(0).getCount() >= recipe.getInputamount()) {
                        canWork = true;
                    }
                } else if (this.itemStackHandler.getStackInSlot(0).getCount() >= recipe.getInputamount()) {
                    canWork = true;
                }
            }
            if (this.deviceCycleTime == 0 && canWork) {
                this.deviceCycleTime = 40;
                this.needCycleTime = 40;
                sendUpdate = true;
            }
            if (this.deviceCycleTime > 0 && canWork) {
                ++this.itemCycleTime;
                if (this.itemCycleTime == 40) {
                    this.itemCycleTime = 0;
                    this.process();
                    this.container.takePower((long)this.getEnergyUsed(), false);
                    sendUpdate = true;
                }
            } else {
                this.itemCycleTime = 0;
            }
            if (this.deviceCycleTime > 0) {
                sendUpdate = true;
            }
        }
        if (sendUpdate) {
            this.markDirty();
            this.state = this.deviceCycleTime > 0 ? (byte)1 : 0;
            this.getWorld().addBlockEvent(this.getPos(), this.getBlockType(), 1, (int)this.state);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachineBase(this), new NetworkRegistry.TargetPoint(this.world.provider.getDimension(), (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), 128.0));
            this.world.notifyNeighborsOfStateChange(this.getPos(), this.getBlockType(), true);
        }
    }

    public void markDirty() {
        super.markDirty();
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachineBase(this), new NetworkRegistry.TargetPoint(this.world.provider.getDimension(), (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), 128.0));
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.itemStackHandler.deserializeNBT(tags.getCompoundTag("items"));
        this.currentTime = tags.getInteger("currentTime");
        String index = tags.getString("recipeIndex");
        if (index.equals("___null")) {
            index = "";
        }
        this.setRecipeIndex(index);
        this.deviceCycleTime = tags.getInteger("deviceCycleTime");
        this.itemCycleTime = tags.getInteger("itemCycleTime");
        this.needCycleTime = tags.getInteger("needCycleTime");
        this.updateCurrentRecipe();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        tags.setTag("items", (NBTBase)this.itemStackHandler.serializeNBT());
        tags.setInteger("currentTime", this.currentTime);
        String index = this.getRecipeIndex();
        if (index == null || index.isEmpty()) {
            index = "___null";
        }
        tags.setString("recipeIndex", index);
        tags.setInteger("deviceCycleTime", this.deviceCycleTime);
        tags.setInteger("itemCycleTime", this.itemCycleTime);
        tags.setInteger("needCycleTime", this.needCycleTime);
        return tags;
    }

    public boolean process() {
        E recipe;
        if (!this.getRecipeIndex().isEmpty() && (recipe = this.getRecipe(this.getRecipeIndex())) != null && this.itemStackHandler.getStackInSlot(0) != null && ((RecipeMachineBase)recipe).matchesExact(this.itemStackHandler.getStackInSlot(0))) {
            if (this.itemStackHandler.getStackInSlot(1) == null || NBTHelper.isInputEqual(this.itemStackHandler.getStackInSlot(1), ((RecipeMachineBase)recipe).getOutput())) {
                this.itemStackHandler.extractItem(0, 1, false);
                ++this.currentTime;
                if (this.currentTime >= ((RecipeMachineBase)recipe).getInputamount()) {
                    ItemStack out = ((RecipeMachineBase)recipe).getOutput().copy();
                    out.setCount(((RecipeMachineBase)recipe).getOutputAmount());
                    this.itemStackHandler.insertItem(1, out, false);
                    this.currentTime = 0;
                }
            }
            return true;
        }
        this.currentTime = 0;
        return false;
    }

    public void updateCurrentRecipe() {
        this.setRecipeIndex("");
        ItemStack inputStack = this.itemStackHandler.getStackInSlot(0);
        if (inputStack != null && inputStack.getCount() > 0) {
            for (String id : this.getRecipes().keySet()) {
                E recipe = this.getRecipe(id);
                if (recipe == null || !((RecipeMachineBase)recipe).matchesExact(inputStack)) continue;
                this.setRecipeIndex(id);
                break;
            }
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new SPacketUpdateTileEntity(this.getPos(), 0, tag);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_HOLDER) {
            return (T)this.container;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_HOLDER) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

