/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.client.gui.base;

import com.blamejared.mas.api.generators.GeneratorBase;
import com.blamejared.mas.tileentities.machine.TileEntityMachineBase;
import com.blamejared.mas.util.RenderUtils;
import java.util.function.Predicate;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiBase
extends GuiContainer {
    Container container;
    TileEntity tile;
    EntityPlayer player;
    String name;
    private boolean title;
    private Predicate<ItemStack> shouldOutline = itemStack -> false;

    public GuiBase(Container container, TileEntity tile, EntityPlayer player, String name) {
        super(container);
        this.container = container;
        this.tile = tile;
        this.name = I18n.translateToLocal((String)name);
        this.player = player;
    }

    public void initGui() {
        this.xSize = 176;
        this.ySize = 166;
        super.initGui();
    }

    protected void drawGuiContainerForegroundLayer(int mx, int my) {
        if (this.title) {
            this.fontRendererObj.drawString(this.name, this.xSize / 2 - this.fontRendererObj.getStringWidth(this.name) / 2, 6, 0xA0A0A0);
        }
        GlStateManager.pushAttrib();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.getMinecraft().renderEngine.bindTexture(this.getTexture());
        GlStateManager.popAttrib();
        if (Keyboard.isKeyDown((int)42) && this.getShouldOutline() != null) {
            this.drawOutlines();
        }
    }

    protected void drawOutlines() {
        GL11.glPushMatrix();
        GlStateManager.pushAttrib();
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        for (int x = 0; x < 9; ++x) {
            ItemStack stack = this.player.inventory.getStackInSlot(x);
            if (stack == ItemStack.EMPTY) continue;
            if (this.getShouldOutline().test(stack)) {
                RenderUtils.drawRectNoFade(8 + 18 * x, 142.0, 280.0, 16.0, 16.0, 0.0f, 0.8f, 0.0f, 2.0f, 1.0f);
                continue;
            }
            RenderUtils.drawRectNoFade(8 + 18 * x, 142.0, 280.0, 16.0, 16.0, 0.8f, 0.0f, 0.0f, 2.0f, 1.0f);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ItemStack stack = this.player.inventory.getStackInSlot(x + y * 9 + 9);
                if (stack == ItemStack.EMPTY) continue;
                if (this.getShouldOutline().test(stack)) {
                    RenderUtils.drawRectNoFade(8 + 18 * x, 84 + y * 18, 280.0, 16.0, 16.0, 0.0f, 0.8f, 0.0f, 2.0f, 1.0f);
                    continue;
                }
                RenderUtils.drawRectNoFade(8 + 18 * x, 84 + y * 18, 280.0, 16.0, 16.0, 0.8f, 0.0f, 0.0f, 2.0f, 1.0f);
            }
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)true);
        GlStateManager.popAttrib();
        GL11.glPopMatrix();
    }

    public ResourceLocation getTexture() {
        return null;
    }

    public void drawMachineProgress(TileEntityMachineBase tile) {
        this.drawMachineProgress(tile.itemCycleTime, tile.needCycleTime);
    }

    public void drawMachineProgress(int itemCycleTime, int needCycleTime) {
        int progressWidth = (int)((float)itemCycleTime / (float)needCycleTime * 33.0f);
        this.drawTexturedModalRect(72, 36, 6, 168, progressWidth, 13);
    }

    public void drawPowerBar(BaseTeslaContainer container) {
        GlStateManager.pushAttrib();
        int barWidth = (int)((float)container.getStoredPower() / (float)container.getCapacity() * 88.0f);
        this.drawTexturedModalRect(44, 60, 44, 166, barWidth, 19);
        GlStateManager.popAttrib();
    }

    public void drawGeneratorProgress(int x, int y, GeneratorBase tile) {
        GlStateManager.pushMatrix();
        GlStateManager.pushAttrib();
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int barHeight = (int)((float)tile.generationTimer / (float)tile.generationTimerDefault * 16.0f);
        this.drawTexturedModalRect(x, y + barHeight, 176, barHeight, 16, barHeight + 16);
        GlStateManager.popAttrib();
        GlStateManager.popMatrix();
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.pushAttrib();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.getMinecraft().renderEngine.bindTexture(this.getTexture());
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        GlStateManager.popAttrib();
    }

    public void setOutlinePredicate(Predicate<ItemStack> predicate) {
        this.shouldOutline = predicate;
    }

    public Predicate<ItemStack> getShouldOutline() {
        return this.shouldOutline;
    }

    public boolean isTitle() {
        return this.title;
    }

    public void setTitle(boolean title) {
        this.title = title;
    }
}

