/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.client.gui.base;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerBase
extends Container {
    public boolean canInteractWith(EntityPlayer player) {
        return true;
    }

    private void updateSlot(Slot slot) {
        this.detectAndSendChanges();
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int idx) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot clickSlot = (Slot)this.inventorySlots.get(idx);
        if (clickSlot != null && clickSlot.getHasStack()) {
            Slot advSlot;
            int x;
            itemStack = clickSlot.getStack();
            if (itemStack == ItemStack.EMPTY) {
                return ItemStack.EMPTY;
            }
            ArrayList<Slot> selectedSlots = new ArrayList<Slot>();
            if (clickSlot.inventory instanceof InventoryPlayer) {
                for (x = 0; x < this.inventorySlots.size(); ++x) {
                    advSlot = (Slot)this.inventorySlots.get(x);
                    if (!advSlot.isItemValid(itemStack)) continue;
                    selectedSlots.add(advSlot);
                }
            } else {
                for (x = 0; x < this.inventorySlots.size(); ++x) {
                    advSlot = (Slot)this.inventorySlots.get(x);
                    if (!(advSlot.inventory instanceof InventoryPlayer) || !advSlot.isItemValid(itemStack)) continue;
                    selectedSlots.add(advSlot);
                }
            }
            if (itemStack != ItemStack.EMPTY) {
                for (Slot d : selectedSlots) {
                    ItemStack tmp;
                    if (!d.isItemValid(itemStack) || itemStack == ItemStack.EMPTY) continue;
                    if (d.getHasStack()) {
                        ItemStack t = d.getStack();
                        if (itemStack == null || !itemStack.isItemEqual(t)) continue;
                        int maxSize = t.getMaxStackSize();
                        if (maxSize > d.getSlotStackLimit()) {
                            maxSize = d.getSlotStackLimit();
                        }
                        int placeAble = maxSize - t.getCount();
                        if (itemStack.getCount() < placeAble) {
                            placeAble = itemStack.getCount();
                        }
                        t.grow(placeAble);
                        itemStack.shrink(placeAble);
                        if (itemStack.getCount() <= 0) {
                            clickSlot.putStack(ItemStack.EMPTY);
                            d.onSlotChanged();
                            this.updateSlot(clickSlot);
                            this.updateSlot(d);
                            return ItemStack.EMPTY;
                        }
                        this.updateSlot(d);
                        continue;
                    }
                    int maxSize = itemStack.getMaxStackSize();
                    if (maxSize > d.getSlotStackLimit()) {
                        maxSize = d.getSlotStackLimit();
                    }
                    if ((tmp = itemStack.copy()).getCount() > maxSize) {
                        tmp.setCount(maxSize);
                    }
                    itemStack.shrink(tmp.getCount());
                    d.putStack(tmp);
                    if (itemStack.getCount() <= 0) {
                        clickSlot.putStack(ItemStack.EMPTY);
                        d.onSlotChanged();
                        this.updateSlot(clickSlot);
                        this.updateSlot(d);
                        return ItemStack.EMPTY;
                    }
                    this.updateSlot(d);
                }
            }
            clickSlot.putStack(itemStack != ItemStack.EMPTY ? itemStack.copy() : ItemStack.EMPTY);
        }
        this.updateSlot(clickSlot);
        return ItemStack.EMPTY;
    }
}

