/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.blocks.machines;

import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.machines.MessageMachineBase;
import com.blamejared.mas.tileentities.machine.TileEntityMachineBase;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMachine
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool isActive = PropertyBool.create((String)"active");

    protected BlockMachine() {
        super(Material.IRON);
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, isActive});
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()).withProperty((IProperty)isActive, (Comparable)Boolean.valueOf(false));
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.SOUTH).withProperty((IProperty)isActive, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean active = false;
        if ((meta & 3) == 1) {
            active = true;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.getHorizontal((int)meta)).withProperty((IProperty)isActive, (Comparable)Boolean.valueOf(active));
    }

    public int getMetaFromState(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
        i = ((Boolean)state.getValue((IProperty)isActive)).booleanValue() ? (i |= 4) : (i |= 0);
        return i;
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.getTileEntity(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.dropInventoryItems((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.updateComparatorOutputLevel(pos, (Block)this);
        }
        super.breakBlock(worldIn, pos, state);
    }

    public void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.getBlockState(pos);
        TileEntity tileentity = worldIn.getTileEntity(pos);
        worldIn.setBlockState(pos, this.getDefaultState().withProperty((IProperty)FACING, iblockstate.getValue((IProperty)FACING)).withProperty((IProperty)isActive, (Comparable)Boolean.valueOf(active)), 3);
        worldIn.setBlockState(pos, this.getDefaultState().withProperty((IProperty)FACING, iblockstate.getValue((IProperty)FACING)).withProperty((IProperty)isActive, (Comparable)Boolean.valueOf(active)), 3);
        if (tileentity != null) {
            tileentity.validate();
            worldIn.setTileEntity(pos, tileentity);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachineBase((TileEntityMachineBase)tileentity), new NetworkRegistry.TargetPoint(worldIn.provider.getDimension(), (double)tileentity.getPos().getX(), (double)tileentity.getPos().getY(), (double)tileentity.getPos().getZ(), 128.0));
        }
    }
}

