/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.blocks.generators.base;

import com.blamejared.mas.MAS;
import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.generator.MessageGenerator;
import com.google.common.base.Predicate;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class BlockBaseGenerator
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool isActive = PropertyBool.create((String)"active");
    private final Class<? extends TileEntity> tileClass;

    public BlockBaseGenerator(Class<? extends TileEntity> tileClass) {
        super(Material.IRON);
        this.tileClass = tileClass;
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.getBlockState(pos);
        TileEntity tileentity = worldIn.getTileEntity(pos);
        worldIn.setBlockState(pos, iblockstate.getBlock().getDefaultState().withProperty((IProperty)FACING, iblockstate.getValue((IProperty)FACING)).withProperty((IProperty)isActive, (Comparable)Boolean.valueOf(active)), 3);
        if (tileentity != null) {
            tileentity.validate();
            worldIn.setTileEntity(pos, tileentity);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageGenerator(tileentity), new NetworkRegistry.TargetPoint(worldIn.provider.getDimension(), (double)tileentity.getPos().getX(), (double)tileentity.getPos().getY(), (double)tileentity.getPos().getZ(), 128.0));
        }
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, isActive});
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean active = false;
        if ((meta & 3) == 1) {
            active = true;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.getHorizontal((int)meta)).withProperty((IProperty)isActive, (Comparable)Boolean.valueOf(active));
    }

    public int getMetaFromState(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
        i = ((Boolean)state.getValue((IProperty)isActive)).booleanValue() ? (i |= 4) : (i |= 0);
        return i;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()).withProperty((IProperty)isActive, (Comparable)Boolean.valueOf(false));
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.isRemote) {
            playerIn.openGui((Object)MAS.INSTANCE, 1, worldIn, pos.getX(), pos.getY(), pos.getZ());
        }
        return true;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity createNewTileEntity(World p_149915_1_, int p_149915_2_) {
        try {
            return this.tileClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

