/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.api.generators;

import com.blamejared.mas.blocks.generators.base.BlockBaseGenerator;
import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.generator.MessageGenerator;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class GeneratorBase
extends TileEntity
implements ITickable {
    public ItemStackHandler itemStackHandler;
    public int generationTimer = -1;
    public int generationTimerDefault = -1;
    public BaseTeslaContainer container;

    public GeneratorBase(int cap, int inventorySize) {
        this.container = new BaseTeslaContainer((long)cap, 50L, 50L);
        this.itemStackHandler = new ItemStackHandler(inventorySize);
    }

    public boolean isGenerating() {
        return this.generationTimer > -1;
    }

    protected boolean pushEnergy() {
        boolean pushed = false;
        for (EnumFacing dir : EnumFacing.VALUES) {
            TileEntity tile = this.world.getTileEntity(this.getPos().offset(dir));
            if (tile == null || !tile.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir.getOpposite()) && !tile.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, dir.getOpposite())) continue;
            BaseTeslaContainer cont = (BaseTeslaContainer)tile.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, dir.getOpposite());
            this.container.takePower(cont.givePower(this.container.takePower(this.container.getOutputRate(), true), false), false);
            if (this.world.isRemote) continue;
            tile.markDirty();
            this.markDirty();
            pushed = true;
        }
        return pushed;
    }

    public void update() {
        boolean sendUpdate = false;
        if (this.generationTimerDefault < 0 && this.container.getStoredPower() < this.container.getCapacity() && this.itemStackHandler.getStackInSlot(0) != null && this.canGenerateEnergy(this.itemStackHandler.getStackInSlot(0))) {
            this.generationTimer = this.getGenerationTime(this.itemStackHandler.getStackInSlot(0));
            this.generationTimerDefault = this.getGenerationTime(this.itemStackHandler.getStackInSlot(0));
            this.itemStackHandler.extractItem(0, 1, false);
            if (!this.world.isRemote) {
                sendUpdate = true;
            }
        }
        if (this.generationTimer < 0) {
            this.generationTimerDefault = -1;
            this.generationTimer = -1;
            if (!this.world.isRemote) {
                sendUpdate = true;
            }
        }
        if (this.pushEnergy()) {
            sendUpdate = true;
        }
        if (this.generationTimerDefault > 0 && this.container.getStoredPower() < this.container.getCapacity()) {
            --this.generationTimer;
            this.container.givePower((long)this.getEnergyGenerated(), false);
            if (!this.world.isRemote) {
                sendUpdate = true;
            }
        }
        if (!this.world.isRemote && sendUpdate) {
            this.markDirty();
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageGenerator(this), new NetworkRegistry.TargetPoint(this.world.provider.getDimension(), (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), 128.0));
            this.world.notifyNeighborsOfStateChange(this.getPos(), this.getBlockType(), true);
        }
        boolean active = true;
        if (!this.isGenerating()) {
            active = false;
        }
        if (this.itemStackHandler.getStackInSlot(0) == null && !this.isGenerating()) {
            active = false;
        }
        if (this.container.getStoredPower() == this.container.getCapacity()) {
            active = false;
        }
        if ((Boolean)this.world.getBlockState(this.getPos()).getValue((IProperty)BlockBaseGenerator.isActive) != active) {
            BlockBaseGenerator.setState(active, this.world, this.pos);
        }
    }

    public void markDirty() {
        super.markDirty();
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageGenerator(this), new NetworkRegistry.TargetPoint(this.world.provider.getDimension(), (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), 128.0));
    }

    public abstract boolean canGenerateEnergy(ItemStack var1);

    public abstract int getGenerationTime(ItemStack var1);

    public abstract int getEnergyGenerated();

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.setTag("items", (NBTBase)this.itemStackHandler.serializeNBT());
        nbt.setInteger("generationTimer", this.generationTimer);
        nbt.setInteger("generationTimerDefault", this.generationTimerDefault);
        nbt.setTag("TeslaContainer", (NBTBase)this.container.serializeNBT());
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.itemStackHandler.deserializeNBT(nbt.getCompoundTag("items"));
        this.generationTimer = nbt.getInteger("generationTimer");
        this.generationTimerDefault = nbt.getInteger("generationTimerDefault");
        this.container = new BaseTeslaContainer(nbt.getCompoundTag("TeslaContainer"));
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new SPacketUpdateTileEntity(this.getPos(), 0, tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readFromNBT(pkt.getNbtCompound());
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_PRODUCER) {
            return (T)this.container;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_PRODUCER) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

