/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.api.capabilities;

import com.blamejared.mas.tileentities.machine.TileEntityMachineBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackHandlerMachine
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    public TileEntityMachineBase tile;
    protected ItemStack[] stacks;

    public ItemStackHandlerMachine(TileEntityMachineBase tile, int size) {
        this.tile = tile;
        this.stacks = new ItemStack[size];
    }

    public ItemStackHandlerMachine(TileEntityMachineBase tile, ItemStack[] stacks) {
        this.tile = tile;
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = new ItemStack[size];
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        this.stacks[slot] = stack;
        if (stack != null && stack.getCount() > 64) {
            stack.setCount(64);
        }
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.length;
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.stacks[slot];
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack == null || stack.getCount() == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.stacks[slot];
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (slot == 0 && !this.tile.isValidInput(stack)) {
            return stack;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing == null) {
                this.stacks[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.getCount() - limit)) : null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.stacks[slot];
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.stacks[slot] = null;
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks[slot] = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.getCount() - toExtract));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return stack.getMaxStackSize();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.setInteger("Slot", i);
            this.stacks[i].writeToNBT(itemTag);
            nbtTagList.appendTag((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setTag("Items", (NBTBase)nbtTagList);
        nbt.setInteger("Size", this.stacks.length);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(nbt.hasKey("Size", 3) ? nbt.getInteger("Size") : this.stacks.length);
        NBTTagList tagList = nbt.getTagList("Items", 10);
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound itemTags = tagList.getCompoundTagAt(i);
            int slot = itemTags.getInteger("Slot");
            if (slot < 0 || slot >= this.stacks.length) continue;
            this.stacks[slot] = new ItemStack(itemTags);
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.length) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.length + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
        if (slot == 0) {
            this.tile.updateCurrentRecipe();
        }
        if (!this.tile.getWorld().isRemote) {
            this.tile.markDirty();
        }
    }
}

