/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.tileentities.misc.energy;

import com.blamejared.mas.api.accumulators.EnumAccumulator;
import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.misc.MessageAccumulator;
import com.blamejared.mas.tileentities.misc.energy.AccumulatorInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityAccumulator
extends TileEntity
implements ITickable {
    public BaseTeslaContainer container;
    public EnumAccumulator enumAccumulator;
    private List<AccumulatorInfo> accumulatorInfos = new ArrayList<AccumulatorInfo>();

    public TileEntityAccumulator() {
    }

    public TileEntityAccumulator(EnumAccumulator acc) {
        this.container = new BaseTeslaContainer(acc.getCapacity(), acc.getInput(), acc.getOutput());
        this.enumAccumulator = acc;
        for (EnumFacing facing : EnumFacing.values()) {
            this.accumulatorInfos.add(new AccumulatorInfo(acc, facing, AccumulatorInfo.AccumulatorIOInfo.INPUT));
        }
    }

    protected boolean pushEnergy() {
        boolean pushed = false;
        for (AccumulatorInfo info : this.accumulatorInfos) {
            if (info.getIoInfo() != AccumulatorInfo.AccumulatorIOInfo.OUTPUT) continue;
            EnumFacing dir = info.getFacing();
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (tile == null || !tile.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir.func_176734_d())) continue;
            BaseTeslaContainer cont = (BaseTeslaContainer)tile.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, dir.func_176734_d());
            this.container.takePower(cont.givePower(this.container.takePower(this.container.getOutputRate(), true), false), false);
            if (this.field_145850_b.field_72995_K) continue;
            tile.func_70296_d();
            this.func_70296_d();
            pushed = true;
        }
        return pushed;
    }

    public void func_73660_a() {
        boolean sendUpdate = false;
        if (this.container.getStoredPower() > 0L && this.pushEnergy()) {
            sendUpdate = true;
        }
        if (!this.field_145850_b.field_72995_K && sendUpdate) {
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAccumulator(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("TeslaContainer", (NBTBase)this.container.serializeNBT());
        NBTTagList list = new NBTTagList();
        for (AccumulatorInfo info : this.accumulatorInfos) {
            list.func_74742_a((NBTBase)info.writeToNBT());
        }
        nbt.func_74782_a("AccumulatorInfos", (NBTBase)list);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.container = new BaseTeslaContainer(nbt.func_74775_l("TeslaContainer"));
        NBTTagList list = nbt.func_150295_c("AccumulatorInfos", 10);
        this.accumulatorInfos.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.accumulatorInfos.add(AccumulatorInfo.readFromNBT(list.func_150305_b(i)));
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.getInfoForFace(facing).getIoInfo() == AccumulatorInfo.AccumulatorIOInfo.OUTPUT) {
            return (T)this.container;
        }
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.getInfoForFace(facing).getIoInfo() == AccumulatorInfo.AccumulatorIOInfo.INPUT) {
            return (T)this.container;
        }
        if (capability == TeslaCapabilities.CAPABILITY_HOLDER && this.getInfoForFace(facing).getIoInfo() != AccumulatorInfo.AccumulatorIOInfo.DISABLED) {
            return (T)this.container;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_PRODUCER && this.getInfoForFace(facing).getIoInfo() == AccumulatorInfo.AccumulatorIOInfo.OUTPUT) {
            return true;
        }
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER && this.getInfoForFace(facing).getIoInfo() == AccumulatorInfo.AccumulatorIOInfo.INPUT) {
            return true;
        }
        if (capability == TeslaCapabilities.CAPABILITY_HOLDER && this.getInfoForFace(facing).getIoInfo() != AccumulatorInfo.AccumulatorIOInfo.DISABLED) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public List<AccumulatorInfo> getAccumulatorInfos() {
        return this.accumulatorInfos;
    }

    public void setAccumulatorInfos(List<AccumulatorInfo> accumulatorInfos) {
        this.accumulatorInfos = accumulatorInfos;
    }

    public AccumulatorInfo getInfoForFace(EnumFacing face) {
        AccumulatorInfo info = null;
        for (AccumulatorInfo accumulatorInfo : this.getAccumulatorInfos()) {
            if (accumulatorInfo.getFacing() != face) continue;
            info = accumulatorInfo;
        }
        return info;
    }
}

