/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.tileentities.misc.energy;

import com.blamejared.mas.api.accumulators.EnumAccumulator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class AccumulatorInfo {
    private final EnumAccumulator type;
    private final EnumFacing facing;
    private AccumulatorIOInfo ioInfo;

    public AccumulatorInfo(EnumAccumulator type, EnumFacing facing, AccumulatorIOInfo ioInfo) {
        this.type = type;
        this.facing = facing;
        this.ioInfo = ioInfo;
    }

    public EnumAccumulator getType() {
        return this.type;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public AccumulatorIOInfo getIoInfo() {
        return this.ioInfo;
    }

    public void setIoInfo(AccumulatorIOInfo ioInfo) {
        this.ioInfo = ioInfo;
    }

    public static AccumulatorInfo readFromNBT(NBTTagCompound tag) {
        return new AccumulatorInfo(EnumAccumulator.values()[tag.func_74762_e("type")], EnumFacing.values()[tag.func_74762_e("facing")], AccumulatorIOInfo.valueOf(tag.func_74779_i("ioInfo")));
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", this.type.ordinal());
        tag.func_74768_a("facing", this.facing.ordinal());
        tag.func_74778_a("ioInfo", this.ioInfo.name());
        return tag;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AccumulatorInfo{");
        sb.append("type=").append((Object)this.type);
        sb.append(", facing=").append(this.facing);
        sb.append(", ioInfo=").append((Object)this.ioInfo);
        sb.append('}');
        return sb.toString();
    }

    public static enum AccumulatorIOInfo {
        INPUT,
        OUTPUT,
        DISABLED;


        public AccumulatorIOInfo getNext() {
            return AccumulatorIOInfo.values()[(this.ordinal() + 1) % AccumulatorIOInfo.values().length];
        }
    }
}

