/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.tileentities.machine;

import com.blamejared.mas.api.capabilities.ItemStackHandlerMachine;
import com.blamejared.mas.api.recipes.machines.RecipeMachineBase;
import com.blamejared.mas.blocks.machines.BlockMachine;
import com.blamejared.mas.network.PacketHandler;
import com.blamejared.mas.network.messages.tiles.machines.MessageMachineBase;
import com.blamejared.mas.util.NBTHelper;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityMachineBase<E extends RecipeMachineBase>
extends TileEntity
implements ITickable {
    public ItemStackHandlerMachine itemStackHandler;
    public int itemCycleTime;
    public int deviceCycleTime;
    public byte state;
    public int needCycleTime;
    public BaseTeslaContainer container;
    private int currentTime = 0;
    private int totalTime = 0;
    private String recipeIndex = "";
    private long prevEnergy;

    public TileEntityMachineBase() {
    }

    public TileEntityMachineBase(long energyCap, int invSize, long inputCap, long outputCap) {
        this.container = new BaseTeslaContainer(energyCap, inputCap, outputCap);
        this.itemStackHandler = new ItemStackHandlerMachine(this, invSize);
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(int totalTime) {
        this.totalTime = totalTime;
    }

    public String getRecipeIndex() {
        return this.recipeIndex;
    }

    public void setRecipeIndex(String recipeIndex) {
        this.recipeIndex = recipeIndex;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public abstract int getEnergyUsed();

    public abstract E getRecipe(String var1);

    public abstract HashMap<String, E> getRecipes();

    public abstract boolean isValidInput(ItemStack var1);

    public void func_73660_a() {
        boolean canWork = false;
        boolean sendUpdate = false;
        if (this.deviceCycleTime > 0 && this.container.getStoredPower() > (long)this.getEnergyUsed()) {
            --this.deviceCycleTime;
            if (!((Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockMachine.isActive)).booleanValue()) {
                ((BlockMachine)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c()).setState(true, this.field_145850_b, this.func_174877_v());
            }
        } else if (((Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockMachine.isActive)).booleanValue()) {
            ((BlockMachine)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c()).setState(false, this.field_145850_b, this.func_174877_v());
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.prevEnergy != this.container.getStoredPower()) {
                this.prevEnergy = this.container.getStoredPower();
                sendUpdate = true;
            }
            RecipeMachineBase recipe = null;
            if (!this.itemStackHandler.getStackInSlot(0).func_190926_b() && !this.getRecipeIndex().isEmpty() && this.container.getStoredPower() > 0L && (recipe = (RecipeMachineBase)this.getRecipe(this.getRecipeIndex())) != null && this.container.getStoredPower() >= (long)this.getEnergyUsed()) {
                if (!this.itemStackHandler.getStackInSlot(1).func_190926_b()) {
                    if (NBTHelper.isInputEqual(recipe.getOutput(), this.itemStackHandler.getStackInSlot(1)) && this.itemStackHandler.getStackInSlot(1).func_190916_E() + recipe.getOutputAmount() < this.itemStackHandler.getStackInSlot(1).func_77976_d() && this.itemStackHandler.getStackInSlot(0).func_190916_E() >= recipe.getInputamount()) {
                        canWork = true;
                    }
                } else if (this.itemStackHandler.getStackInSlot(0).func_190916_E() >= recipe.getInputamount()) {
                    canWork = true;
                }
            }
            if (this.deviceCycleTime == 0 && canWork) {
                this.deviceCycleTime = 40;
                this.needCycleTime = 40;
                sendUpdate = true;
            }
            if (this.deviceCycleTime > 0 && canWork) {
                ++this.itemCycleTime;
                if (this.itemCycleTime == 40) {
                    this.itemCycleTime = 0;
                    this.process();
                    this.container.takePower((long)this.getEnergyUsed(), false);
                    sendUpdate = true;
                }
            } else {
                this.itemCycleTime = 0;
            }
            if (this.deviceCycleTime > 0) {
                sendUpdate = true;
            }
        }
        if (sendUpdate) {
            this.func_70296_d();
            this.state = this.deviceCycleTime > 0 ? (byte)1 : 0;
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, (int)this.state);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachineBase(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachineBase(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.itemStackHandler.deserializeNBT(tags.func_74775_l("items"));
        this.currentTime = tags.func_74762_e("currentTime");
        String index = tags.func_74779_i("recipeIndex");
        if (index.equals("___null")) {
            index = "";
        }
        this.setRecipeIndex(index);
        this.deviceCycleTime = tags.func_74762_e("deviceCycleTime");
        this.itemCycleTime = tags.func_74762_e("itemCycleTime");
        this.needCycleTime = tags.func_74762_e("needCycleTime");
        this.updateCurrentRecipe();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        tags.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        tags.func_74768_a("currentTime", this.currentTime);
        String index = this.getRecipeIndex();
        if (index == null || index.isEmpty()) {
            index = "___null";
        }
        tags.func_74778_a("recipeIndex", index);
        tags.func_74768_a("deviceCycleTime", this.deviceCycleTime);
        tags.func_74768_a("itemCycleTime", this.itemCycleTime);
        tags.func_74768_a("needCycleTime", this.needCycleTime);
        return tags;
    }

    public boolean process() {
        E recipe;
        if (!this.getRecipeIndex().isEmpty() && (recipe = this.getRecipe(this.getRecipeIndex())) != null && !this.itemStackHandler.getStackInSlot(0).func_190926_b() && ((RecipeMachineBase)recipe).matchesExact(this.itemStackHandler.getStackInSlot(0))) {
            if (this.itemStackHandler.getStackInSlot(1).func_190926_b() || NBTHelper.isInputEqual(this.itemStackHandler.getStackInSlot(1), ((RecipeMachineBase)recipe).getOutput())) {
                this.itemStackHandler.extractItem(0, 1, false);
                ++this.currentTime;
                if (this.currentTime >= ((RecipeMachineBase)recipe).getInputamount()) {
                    ItemStack out = ((RecipeMachineBase)recipe).getOutput().func_77946_l();
                    out.func_190920_e(((RecipeMachineBase)recipe).getOutputAmount());
                    this.itemStackHandler.insertItem(1, out, false);
                    this.currentTime = 0;
                }
            }
            return true;
        }
        this.currentTime = 0;
        return false;
    }

    public void updateCurrentRecipe() {
        String oldIndex = this.getRecipeIndex();
        this.setRecipeIndex("");
        ItemStack inputStack = this.itemStackHandler.getStackInSlot(0);
        if (!inputStack.func_190926_b() && inputStack.func_190916_E() > 0) {
            for (String id : this.getRecipes().keySet()) {
                E recipe = this.getRecipe(id);
                if (recipe == null || !((RecipeMachineBase)recipe).matchesExact(inputStack)) continue;
                this.setRecipeIndex(id);
                break;
            }
        }
        if (!oldIndex.equals(this.getRecipeIndex())) {
            this.currentTime = 0;
            this.itemCycleTime = 0;
            this.deviceCycleTime = 40;
            this.needCycleTime = 40;
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return (T)this.container;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

