/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mas.network.messages.tiles.misc;

import com.blamejared.mas.tileentities.misc.energy.AccumulatorInfo;
import com.blamejared.mas.tileentities.misc.energy.TileEntityAccumulator;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageAccumulator
implements IMessage,
IMessageHandler<MessageAccumulator, IMessage> {
    private int x;
    private int y;
    private int z;
    private long energy;
    private List<AccumulatorInfo> infos;

    public MessageAccumulator() {
    }

    public MessageAccumulator(TileEntity tile) {
        this((TileEntityAccumulator)tile);
    }

    public MessageAccumulator(TileEntityAccumulator tile) {
        this.x = tile.func_174877_v().func_177958_n();
        this.y = tile.func_174877_v().func_177956_o();
        this.z = tile.func_174877_v().func_177952_p();
        this.energy = tile.container.getStoredPower();
        this.infos = tile.getAccumulatorInfos();
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.energy = buf.readLong();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagList list = tag.func_150295_c("infos", 10);
        this.infos = new ArrayList<AccumulatorInfo>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.infos.add(AccumulatorInfo.readFromNBT(list.func_150305_b(i)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeLong(this.energy);
        NBTTagList list = new NBTTagList();
        for (AccumulatorInfo info : this.infos) {
            list.func_74742_a((NBTBase)info.writeToNBT());
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("infos", (NBTBase)list);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public IMessage onMessage(MessageAccumulator message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> this.handle(message, ctx));
        return null;
    }

    private void handle(MessageAccumulator message, MessageContext ctx) {
        TileEntity tileEntity;
        if (FMLClientHandler.instance().getClient().field_71441_e != null && (tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(new BlockPos(message.x, message.y, message.z))) instanceof TileEntityAccumulator) {
            long cap = ((TileEntityAccumulator)tileEntity).container.getCapacity();
            long input = ((TileEntityAccumulator)tileEntity).container.getInputRate();
            long output = ((TileEntityAccumulator)tileEntity).container.getOutputRate();
            ((TileEntityAccumulator)tileEntity).container = new BaseTeslaContainer(message.energy, cap, input, output);
            ((TileEntityAccumulator)tileEntity).setAccumulatorInfos(message.infos);
        }
    }
}

